package com.franklin.ideaplugin.easytesting.spring.config;

import com.franklin.ideaplugin.easytesting.core.invoke.MethodInvokerRegistry;
import com.franklin.ideaplugin.easytesting.core.rpc.NettyServer;
import com.franklin.ideaplugin.easytesting.core.utils.PortUtils;
import com.franklin.ideaplugin.easytesting.spring.controller.EasyTestingControllerMethodController;
import com.franklin.ideaplugin.easytesting.spring.invoke.SpringMethodInvoker;
import com.franklin.ideaplugin.easytesting.spring.lifecycle.EasyTestingLifeCycle;
import com.franklin.ideaplugin.easytesting.spring.registry.SpringFileRegistry;
import com.franklin.ideaplugin.easytesting.spring.registry.SpringLibFileRegistry;
import com.franklin.ideaplugin.easytesting.spring.registry.SpringPortHolder;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import java.io.IOException;
import java.util.Objects;

/**
 * @author Ye Junhui
 * @since 2023/5/15
 */
@Configuration
@ConditionalOnProperty(name = "easy-testing.enable",havingValue = "true")
public class EasyTestingAutoConfiguration {

    @Bean
    public EasyTestingProperties easyTestingProperties(){
        return new EasyTestingProperties();
    }

    @Bean
    @Autowired
    public EasyTestingLifeCycle easyTestingLifeCycle(
            SpringMethodInvoker springMethodInvoker,
            NettyServer nettyServer,
            EasyTestingProperties easyTestingProperties
    ){
        return new EasyTestingLifeCycle(springMethodInvoker,nettyServer,easyTestingProperties);
    }

    @Bean
    @Autowired
    public SpringPortHolder springPortHolder(
            ServerProperties serverProperties
    ){
        //注册端口号
        try {
            Integer serverPort = serverProperties.getPort();
            if (Objects.isNull(serverPort)){
                serverPort = 8080;
            }
            int port = ((serverPort + 20202) * serverProperties.hashCode()) % 65535 + 1;
            port = Math.abs(port);
            int usablePort = PortUtils.getUsablePort(port);
            return new SpringPortHolder(usablePort);
        } catch (IOException e) {
            return new SpringPortHolder(-1);
        }
    }

    @Bean
    @Autowired
    public SpringFileRegistry springFileRegistry(
            SpringPortHolder springPortHolder,
            EasyTestingProperties easyTestingProperties
    ){
        return new SpringFileRegistry(springPortHolder.getPort(),easyTestingProperties);
    }

    @Bean
    public SpringUtil springUtil(){
        return new SpringUtil();
    }

    @Bean
    public SpringMethodInvoker springMethodInvoker(){
        return new SpringMethodInvoker();
    }

    @Bean
    @Autowired
    public EasyTestingControllerMethodController easyTestingControllerMethodController(
            SpringMethodInvoker springMethodInvoker
    ){
        return new EasyTestingControllerMethodController(springMethodInvoker);
    }

    @Bean("easyTestingNettyServer")
    @Autowired
    public NettyServer easyTestingNettyServer(
            SpringPortHolder springPortHolder
    ){
        if (springPortHolder.getPort() < 0){
            return new NettyServer(-1);
        }
        //启动netty服务器
        NettyServer nettyServer = new NettyServer(springPortHolder.getPort());
        return nettyServer;
    }

}
