package com.franklin.ideaplugin.easytesting.spring.controller;

import com.franklin.ideaplugin.easytesting.core.log.ILogger;
import com.franklin.ideaplugin.easytesting.core.log.LoggerFactory;
import com.franklin.ideaplugin.easytesting.core.rpc.NettyServer;
import com.franklin.ideaplugin.easytesting.core.rpc.entity.ETRsp;
import com.franklin.ideaplugin.easytesting.core.rpc.entity.MethodInvokeData;
import com.franklin.ideaplugin.easytesting.core.utils.JsonUtils;
import com.franklin.ideaplugin.easytesting.core.utils.MethodUtils;
import com.franklin.ideaplugin.easytesting.spring.constants.StrPool;
import com.franklin.ideaplugin.easytesting.spring.invoke.SpringMethodInvoker;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;

/**
 * @author Ye Junhui
 * @since 2023/5/18
 */
@RestController
@ConditionalOnBean(SpringMethodInvoker.class)
@RequiredArgsConstructor
public class EasyTestingControllerMethodController {

    private static final ILogger log = LoggerFactory.getLogger(NettyServer.class);

    private final SpringMethodInvoker springMethodInvoker;

    @PostMapping(StrPool.INNER_REQUEST_PATH)
    public ETRsp<String> execute(@RequestBody MethodInvokeData methodInvokeData){
        try {
            Class<?> targetClass = Class.forName(methodInvokeData.getClassQualifiedName());
            Class<?>[] paramTypes = MethodUtils.resolveParamTypes(methodInvokeData);
            Method declaredMethod = targetClass.getDeclaredMethod(methodInvokeData.getMethodName(), paramTypes);
            declaredMethod.setAccessible(true);

            //参数值
            Object[] params = methodInvokeData.getParameterMap().values().stream()
                    .map(MethodUtils::parseValue)
                    .toArray();

            //重置请求头，避免重新请求
            methodInvokeData.setHeaderMap(new LinkedHashMap<>());
            Object result = springMethodInvoker.invoke(methodInvokeData, targetClass, declaredMethod, params);
            log.info("Easy-Testing -> method execute result : \n{}", JsonUtils.toJSONString(result));
            return ETRsp.success("success");
        }catch (Exception e){
            log.error("Easy-Testing -> method execute fail",e);
            return ETRsp.fail("error");
        }
    }
}
