package com.franklin.ideaplugin.easytesting.spring.lifecycle;

import cn.hutool.core.util.SystemPropsUtil;
import com.franklin.ideaplugin.easytesting.core.constants.EasyTestingProps;
import com.franklin.ideaplugin.easytesting.core.invoke.MethodInvokerRegistry;
import com.franklin.ideaplugin.easytesting.core.registry.FileRegistry;
import com.franklin.ideaplugin.easytesting.core.rpc.NettyServer;
import com.franklin.ideaplugin.easytesting.spring.config.EasyTestingProperties;
import com.franklin.ideaplugin.easytesting.spring.invoke.SpringMethodInvoker;
import com.franklin.ideaplugin.easytesting.spring.registry.SpringPortHolder;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/**
 * @author Ye Junhui
 * @since 2023/5/21
 */
@RequiredArgsConstructor
public class EasyTestingLifeCycle implements InitializingBean,DisposableBean {

    private final SpringMethodInvoker springMethodInvoker;
    private final NettyServer nettyServer;
    private final EasyTestingProperties easyTestingProperties;


    @Override
    public void afterPropertiesSet() throws Exception {
        if (!nettyServer.isEnable()){
            return;
        }

        //注册方法调用器
        MethodInvokerRegistry.addMethodInvoker(springMethodInvoker);

        //启动netty服务器
        nettyServer.start();
    }

    @Override
    public void destroy() throws Exception {
        FileRegistry.shutDown(SpringUtil.getAppName());
    }
}
