package com.franklin.ideaplugin.easytesting.spring.registry;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.franklin.ideaplugin.easytesting.core.registry.FileRegistry;
import com.franklin.ideaplugin.easytesting.core.utils.ReflectionUtils;
import com.franklin.ideaplugin.easytesting.spring.config.EasyTestingProperties;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

import java.util.List;

/**
 * @author Ye Junhui
 * @since 2023/5/16
 */
@RequiredArgsConstructor
public class SpringFileRegistry implements BeanPostProcessor, InitializingBean {

    private final int port;
    private final EasyTestingProperties easyTestingProperties;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        //加载类路径
        Class<?> beanClass = bean.getClass();

        //注册
        String appName = SpringUtil.getAppName();
        FileRegistry.registryServer(appName,beanClass,this.port);

        //注册父类
        List<Class<?>> classAllSuperClasses = ReflectionUtils.getClassAllSuperClasses(beanClass);
        for (Class<?> classAllSuperClass : classAllSuperClasses) {
            FileRegistry.registryServer(appName,classAllSuperClass,this.port);
        }

        //注册父接口
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (ArrayUtil.isNotEmpty(interfaces)){
            for (Class<?> anInterface : interfaces) {
                FileRegistry.registryServer(appName,anInterface,this.port);
            }
        }

        return bean;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        new SpringLibFileRegistry(this.port).registry();
    }
}
