package com.franklin.ideaplugin.easytesting.spring.registry;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.net.URLDecoder;
import com.franklin.ideaplugin.easytesting.core.registry.FileRegistry;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @author Ye Junhui
 * @since 2023/5/22
 */
@RequiredArgsConstructor
@Slf4j
public class SpringLibFileRegistry {

    private final int port;

    private final static String JRE_LIB = "jre/lib";

    public void registry() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources(ResourcePatternResolver.CLASSPATH_ALL_URL_PREFIX);
            for (Resource resource : resources) {
                if (resource.isReadable()) {
                    URL url = resource.getURL();
                    String path = url.getPath();
                    path = URLDecoder.decodeForPath(path, StandardCharsets.UTF_8);
                    File file = FileUtil.file(path);
                    String filePath = file.getAbsolutePath();
                    filePath = filePath.substring(0,filePath.length() - 1);
                    filePath = filePath.replace("\\","/");
                    try {
                        if (filePath.contains(JRE_LIB)){
                            int index = filePath.indexOf(JRE_LIB);
                            filePath = filePath.substring(0,index + JRE_LIB.length());
                        }
                        FileRegistry.registryServerForLib(SpringUtil.getAppName(), filePath,port);
                    } catch (Exception e) {
//                            log.error("Easy-Testing -> method registry fail , {}" ,registryPath);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
