package io.gitee.yxsnake.framework.data.scope.config;

import cn.hutool.core.util.StrUtil;
import io.gitee.yxsnake.framework.core.utils.BizAssert;
import io.gitee.yxsnake.framework.core.utils.SpringUtils;
import io.gitee.yxsnake.framework.data.scope.interceptor.PlusDataPermissionInterceptor;
import io.gitee.yxsnake.framework.data.scope.service.SysDataScopeService;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;

/**
 * @author snake
 * @description
 * @since 2024/11/22 16:22
 */
@AutoConfiguration
public class DataScopeConfig {

    /**
     * 数据权限拦截器
     */
    @Bean("dataPermissionInterceptor")
    public PlusDataPermissionInterceptor dataPermissionInterceptor() {
        String property = SpringUtils.getProperty("mybatis-plus.mapperPackage");
        BizAssert.isTrue("请配置权限扫描的mapper路径属性：mybatis-plus.mapperPackage", StrUtil.isBlank(property));
        return new PlusDataPermissionInterceptor(SpringUtils.getProperty("mybatis-plus.mapperPackage"));
    }

    /**
     * 数据权限处理实现
     */
    @Bean("sdss")
    public SysDataScopeService sysDataScopeService() {
        return new SysDataScopeService();
    }
}
