package webservice.utils;

import webservice.ParseException;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;


public class WebServiceUtils {

    private static final Logger LOGGER = Logger.getLogger("WebServiceUtils");

    //webservice请求返回的内容
    public static final String BODY="body";
    //webservice请求返回的状态代码
    public static final String CODE="responseCode";


    /**
     * 通过服务地址与SOAP的xml完成webservice请求
     * @param urlString
     * @param xmlString
     * @return
     */
    public Map<String,String> webServiceRequest(String urlString,String xmlString){
        long start = System.currentTimeMillis();
        HttpURLConnection connection = null;
        OutputStream os = null;
        Map<String, String> reslut = new HashMap<>();

        try {
            URL url=new URL(urlString);
            connection=(HttpURLConnection) url.openConnection();
            //设置请求方式
            connection.setRequestMethod("POST");//(固定的人方法)
            connection.setRequestProperty("content-type", "text/xml;charset=utf-8");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            os = connection.getOutputStream();
            os.write(xmlString.getBytes());
        } catch (IOException e) {
            LOGGER.log(Level.WARNING,"Exception caught",e);
        }

        StringBuilder sb = new StringBuilder();
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String temp=null;
            int responseCode = connection.getResponseCode();
            if (200 == responseCode) {//表示服务端响应成功
                is = connection.getInputStream();
                isr = new InputStreamReader(is);
                br = new BufferedReader(isr);

                while ((temp = br.readLine()) != null) {
                    sb.append(temp);
                }

                reslut.put(WebServiceUtils.CODE, responseCode + "");
                reslut.put(WebServiceUtils.BODY, sb.toString());
            }else {
                is = connection.getInputStream();
                isr = new InputStreamReader(is);
                br = new BufferedReader(isr);

                while ((temp = br.readLine()) != null) {
                    sb.append(temp);
                }
                reslut.put(WebServiceUtils.CODE, responseCode+"");
                reslut.put(WebServiceUtils.BODY, sb.toString());
                Logger logger=Logger.getLogger("WebserviceUtil");
                logger.log(Level.WARNING,"webservice返回状态代码:"+responseCode+"相应内容为:"+sb);
            }
        } catch (IOException e) {
            LOGGER.log(Level.WARNING,"Exception caught",e);
        }finally {
            try {
                if (!Objects.isNull(br)) {
                    br.close();
                }
                if (!Objects.isNull(isr)) {
                    isr.close();
                }
                if (!Objects.isNull(is)) {
                    is.close();
                }
                if (!Objects.isNull(os)) {
                    os.close();
                }
            }catch (IOException e){
                LOGGER.log(Level.WARNING,"Exception caught",e);
            }
        }
        long finish = System.currentTimeMillis();
        LOGGER.info("webService调用耗时为"+(finish-start)+"ms,请求地址:"+urlString);
        return reslut;
    }

    /**
     * 根据标签名获得其中的内容;注：标签不带属性
     * @param tableName 标签名
     * @param xmlString 需要截取的xml
     * @return
     */
    public String cutOutXml(String tableName, String xmlString){
        String[] split = xmlString.split(tableName);
        if (split.length==0){
            throw new ParseException("没有找到对应的标签");
        }
        return split[1].substring(1,split[1].length()-2);
    }
}
