package io.gitee.zhangbinhub.acp.boot.ftp

import io.gitee.zhangbinhub.acp.boot.ftp.conf.AcpFtpServerConfiguration
import io.gitee.zhangbinhub.acp.boot.ftp.init.AcpFtpServerInitialization
import io.gitee.zhangbinhub.acp.boot.ftp.user.UserFactory
import io.gitee.zhangbinhub.acp.boot.init.AcpInitialization
import org.noear.solon.annotation.Bean
import org.noear.solon.annotation.Configuration
import org.noear.solon.annotation.Import
import org.noear.solon.annotation.Inject

@Configuration
@Import(AcpFtpServerConfiguration::class)
class AcpFtpAutoConfiguration {
    @Bean(index = 1)
    fun acpFtpServerInitialization(
        @Inject acpFtpServerConfiguration: AcpFtpServerConfiguration,
        @Inject userFactory: MutableMap<String, UserFactory>?
    ): AcpInitialization = AcpFtpServerInitialization(acpFtpServerConfiguration, userFactory)
}