package io.gitee.zhangbinhub.acp.boot.ftp.base

import io.gitee.zhangbinhub.acp.boot.ftp.user.UserFactory
import java.lang.reflect.InvocationTargetException
import java.util.concurrent.ConcurrentHashMap

/**
 * @since JDK 17
 */
abstract class BaseInitFtpServer {
    companion object {

        private val userFactoryMap = ConcurrentHashMap<String, UserFactory>()

        @JvmStatic
        internal fun addUserFactory(name: String, userFactory: UserFactory) {
            userFactoryMap[name] = userFactory
        }

        @JvmStatic
        @Throws(
            ClassNotFoundException::class,
            NoSuchMethodException::class,
            IllegalAccessException::class,
            InvocationTargetException::class,
            InstantiationException::class
        )
        internal fun getUserFactory(name: String?): UserFactory? {
            return userFactoryMap[name]
        }
    }
}