package io.gitee.zhangbinhub.acp.boot.ftp.client

import io.gitee.zhangbinhub.acp.core.common.exceptions.EnumValueUndefinedException
import org.apache.commons.net.ftp.FTPClient

/**
 * @since JDK 17
 */
enum class AcpFtpConnectMode(val value: Int) {
    ACTIVE_LOCAL(FTPClient.ACTIVE_LOCAL_DATA_CONNECTION_MODE),
    ACTIVE_REMOTE(FTPClient.ACTIVE_REMOTE_DATA_CONNECTION_MODE),
    PASSIVE_LOCAL(FTPClient.PASSIVE_LOCAL_DATA_CONNECTION_MODE),
    PASSIVE_REMOTE(FTPClient.PASSIVE_REMOTE_DATA_CONNECTION_MODE);

    companion object {

        private var map: MutableMap<String, AcpFtpConnectMode> = mutableMapOf()

        init {
            for (type in entries) {
                map[type.name.uppercase()] = type
            }
        }

        @JvmStatic
        @Throws(EnumValueUndefinedException::class)
        fun getEnum(name: String): AcpFtpConnectMode {
            if (map.containsKey(name.uppercase())) {
                return map.getValue(name.uppercase())
            }
            throw EnumValueUndefinedException(AcpFtpConnectMode::class.java, name)
        }
    }
}