package io.gitee.zhangbinhub.acp.boot.ftp.client

import com.jcraft.jsch.ChannelSftp
import io.gitee.zhangbinhub.acp.core.common.exceptions.EnumValueUndefinedException

/**
 * @since JDK 17
 */
enum class AcpSftpChannelMode(val value: Int) {
    OVERWRITE(ChannelSftp.OVERWRITE),
    RESUME(ChannelSftp.RESUME),
    APPEND(ChannelSftp.APPEND);

    companion object {

        private var map: MutableMap<String, AcpSftpChannelMode> = mutableMapOf()

        init {
            for (type in entries) {
                map[type.name.uppercase()] = type
            }
        }

        @JvmStatic
        @Throws(EnumValueUndefinedException::class)
        fun getEnum(name: String): AcpSftpChannelMode {
            if (map.containsKey(name.uppercase())) {
                return map.getValue(name.uppercase())
            }
            throw EnumValueUndefinedException(AcpSftpChannelMode::class.java, name)
        }
    }
}