package io.gitee.zhangbinhub.acp.boot.ftp.init

import io.gitee.zhangbinhub.acp.boot.ftp.conf.AcpFtpServerConfiguration
import io.gitee.zhangbinhub.acp.boot.ftp.init.task.InitFtpServer
import io.gitee.zhangbinhub.acp.boot.ftp.user.UserFactory
import io.gitee.zhangbinhub.acp.boot.init.AcpInitialization
import io.gitee.zhangbinhub.acp.boot.listener.AcpApplicationStopListener

/**
 * @since JDK 17
 */
class AcpFtpServerInitialization(
    private val acpFtpServerConfiguration: AcpFtpServerConfiguration,
    private val userFactory: MutableMap<String, UserFactory>?
) : AcpInitialization {

    override val name: String
        get() = "ftp server setup server"

    /**
     * 启动ftp服务
     */
    override fun doInit() {
        AcpApplicationStopListener.addAllService(InitFtpServer.startFtpServer(acpFtpServerConfiguration, userFactory))
    }
}
