/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.ftp.client;

import io.gitee.zhangbinhub.acp.boot.ftp.client.AcpFtpConnectMode;
import io.gitee.zhangbinhub.acp.boot.ftp.client.BaseClient;
import io.gitee.zhangbinhub.acp.boot.ftp.exceptions.FtpException;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0003H\u0002J\u0018\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020*H\u0002J\u0006\u00101\u001a\u00020\u0003J\u0010\u00102\u001a\u00020(2\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00103\u001a\u00020(J\f\u00104\u001a\b\u0012\u0004\u0012\u00020605R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00067"}, d2={"Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpFtpClient;", "Lio/gitee/zhangbinhub/acp/boot/ftp/client/BaseClient;", "hostname", "", "port", "", "username", "password", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "log", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "ftpClient", "Lorg/apache/commons/net/ftp/FTPClient;", "outputStream", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "raf", "Ljava/io/RandomAccessFile;", "serverCharset", "getServerCharset", "()Ljava/lang/String;", "setServerCharset", "(Ljava/lang/String;)V", "connectMode", "Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpFtpConnectMode;", "getConnectMode", "()Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpFtpConnectMode;", "setConnectMode", "(Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpFtpConnectMode;)V", "activeServerHost", "getActiveServerHost", "setActiveServerHost", "activeServerPort", "getActiveServerPort", "()I", "setActiveServerPort", "(I)V", "connect", "", "createDirectory", "", "remotePath", "uploadFile", "remoteFile", "localFile", "Ljava/io/File;", "finallyFunc", "doDownLoad", "doUpLoad", "doDelete", "getFileEntityList", "", "Lorg/apache/commons/net/ftp/FTPFile;", "acp-solon-boot-ftp"})
public final class AcpFtpClient
extends BaseClient {
    @NotNull
    private final LogFactory log;
    @NotNull
    private final FTPClient ftpClient;
    @Nullable
    private OutputStream outputStream;
    @Nullable
    private InputStream inputStream;
    @Nullable
    private RandomAccessFile raf;
    @NotNull
    private String serverCharset;
    @NotNull
    private AcpFtpConnectMode connectMode;
    @Nullable
    private String activeServerHost;
    private int activeServerPort;

    public AcpFtpClient(@NotNull String hostname, int port, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        super(hostname, port, username, password);
        this.log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, this.getClass(), (int)0, (int)2, null);
        this.ftpClient = new FTPClient();
        this.serverCharset = "ISO-8859-1";
        this.connectMode = AcpFtpConnectMode.ACTIVE_LOCAL;
    }

    @NotNull
    public final String getServerCharset() {
        return this.serverCharset;
    }

    public final void setServerCharset(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverCharset = string;
    }

    @NotNull
    public final AcpFtpConnectMode getConnectMode() {
        return this.connectMode;
    }

    public final void setConnectMode(@NotNull AcpFtpConnectMode acpFtpConnectMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)acpFtpConnectMode), (String)"<set-?>");
        this.connectMode = acpFtpConnectMode;
    }

    @Nullable
    public final String getActiveServerHost() {
        return this.activeServerHost;
    }

    public final void setActiveServerHost(@Nullable String string) {
        this.activeServerHost = string;
    }

    public final int getActiveServerPort() {
        return this.activeServerPort;
    }

    public final void setActiveServerPort(int n) {
        this.activeServerPort = n;
    }

    private final boolean connect() throws Exception {
        try {
            this.ftpClient.connect(this.getHostname(), this.getPort());
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                this.log.error("ftp connect error,hostname=" + this.getHostname() + " port:" + this.getPort());
                return false;
            }
            if (!this.ftpClient.login(this.getUsername(), this.getPassword())) {
                this.ftpClient.disconnect();
                this.log.error("ftp login error,username=" + this.getUsername() + " password=" + this.getPassword());
                return false;
            }
            this.ftpClient.setFileType(2);
            switch (WhenMappings.$EnumSwitchMapping$0[this.connectMode.ordinal()]) {
                case 1: {
                    this.ftpClient.enterLocalActiveMode();
                    break;
                }
                case 2: {
                    this.ftpClient.enterRemoteActiveMode(InetAddress.getByName(this.activeServerHost), this.activeServerPort);
                    break;
                }
                case 3: {
                    this.ftpClient.enterLocalPassiveMode();
                    break;
                }
                case 4: {
                    this.ftpClient.enterRemotePassiveMode();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.log.info("ftp server by hostname:{" + this.getHostname() + "} username:{" + this.getUsername() + "} is connect successFull");
            return true;
        }
        catch (Exception e) {
            throw new Exception("ftp connect failed!");
        }
    }

    private final void createDirectory(String remotePath) throws Exception {
        if (!Intrinsics.areEqual((Object)remotePath, (Object)"/") && !this.ftpClient.changeWorkingDirectory(remotePath)) {
            String[] tmpFold = this.parseCurrAndSubFold(remotePath);
            String fold = tmpFold[0];
            String subFold = tmpFold[1];
            if (!CommonTools.isNullStr((String)fold) && !this.ftpClient.changeWorkingDirectory(fold)) {
                if (this.ftpClient.makeDirectory(fold)) {
                    this.ftpClient.changeWorkingDirectory(fold);
                } else {
                    throw new Exception("create remote fold is failed!");
                }
            }
            this.createDirectory(subFold);
        }
    }

    private final boolean uploadFile(String remoteFile, File localFile) throws Exception {
        long remoteSize = 0L;
        this.ftpClient.enterLocalPassiveMode();
        FTPFile[] files = this.ftpClient.listFiles(remoteFile);
        if (files.length == 1) {
            long localSize;
            remoteSize = files[0].getSize();
            if (remoteSize >= (localSize = localFile.length())) {
                if (!this.ftpClient.deleteFile(remoteFile)) {
                    throw new Exception("delete remote file is failed!");
                }
                remoteSize = 0L;
            }
        } else {
            remoteSize = 0L;
        }
        this.raf = new RandomAccessFile(localFile, "r");
        this.outputStream = this.ftpClient.appendFileStream(remoteFile);
        if (remoteSize > 0L) {
            this.ftpClient.setRestartOffset(remoteSize);
            RandomAccessFile randomAccessFile = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile);
            randomAccessFile.seek(remoteSize);
        }
        byte[] bytes = new byte[1024];
        RandomAccessFile randomAccessFile = this.raf;
        Intrinsics.checkNotNull((Object)randomAccessFile);
        int c = randomAccessFile.read(bytes);
        while (c != -1) {
            OutputStream outputStream = this.outputStream;
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.write(bytes, 0, c);
            RandomAccessFile randomAccessFile2 = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile2);
            c = randomAccessFile2.read(bytes);
        }
        OutputStream outputStream = this.outputStream;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.flush();
        RandomAccessFile randomAccessFile3 = this.raf;
        Intrinsics.checkNotNull((Object)randomAccessFile3);
        randomAccessFile3.close();
        OutputStream outputStream2 = this.outputStream;
        Intrinsics.checkNotNull((Object)outputStream2);
        outputStream2.close();
        return this.ftpClient.completePendingCommand();
    }

    private final void finallyFunc() {
        try {
            Closeable it;
            InputStream inputStream = this.inputStream;
            if (inputStream != null) {
                it = inputStream;
                boolean bl = false;
                ((InputStream)it).close();
                this.inputStream = null;
            }
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                it = outputStream;
                boolean bl = false;
                ((OutputStream)it).close();
                this.outputStream = null;
            }
            RandomAccessFile randomAccessFile = this.raf;
            if (randomAccessFile != null) {
                it = randomAccessFile;
                boolean bl = false;
                ((RandomAccessFile)it).close();
                this.raf = null;
            }
            if (this.ftpClient.isConnected()) {
                this.ftpClient.disconnect();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String doDownLoad() {
        try {
            Object object;
            if (CommonTools.isNullStr((String)this.getLocalPath())) {
                throw new FtpException("localPath is null");
            }
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new FtpException("fileName is null");
            }
            String string = this.getLocalPath();
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            String string3 = StringsKt.replace$default((String)string, (String)"\\", (String)string2, (boolean)false, (int)4, null);
            String string4 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"separator");
            String path = StringsKt.replace$default((String)string3, (String)"/", (String)string4, (boolean)false, (int)4, null);
            if (!this.connect()) {
                throw new FtpException("ftp server login failed!");
            }
            this.formatRemotePath();
            String string5 = this.getRemotePath() + this.getFileName();
            Charset charset = Charset.forName(this.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = string5.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Charset charset2 = Charset.forName(this.serverCharset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            String remoteFile = new String(byArray, charset2);
            String localFile = path + File.separator + this.getFileName() + ".tmp";
            String localRealFile = path + File.separator + this.getFileName();
            this.ftpClient.enterLocalPassiveMode();
            FTPFile[] files = this.ftpClient.listFiles(remoteFile);
            if (files.length != 1) {
                throw new FtpException("remote file is not find!");
            }
            long lRemoteSize = files[0].getSize();
            File realFile = new File(localRealFile);
            if (realFile.exists()) {
                this.log.info("ftp download successFull: " + localRealFile);
                String string6 = localRealFile;
                return string6;
            }
            File file = new File(localFile);
            if (file.exists()) {
                long localSize = file.length();
                if (localSize == lRemoteSize) {
                    Object object2;
                    if (file.renameTo(realFile)) {
                        this.log.info("ftp download successFull: " + localRealFile);
                        object2 = localRealFile;
                    } else {
                        object2 = "";
                    }
                    String string7 = object2;
                    return string7;
                }
                this.outputStream = new FileOutputStream(file, true);
                this.ftpClient.setRestartOffset(localSize);
            } else {
                this.outputStream = new FileOutputStream(file);
            }
            this.ftpClient.enterLocalPassiveMode();
            this.inputStream = this.ftpClient.retrieveFileStream(remoteFile);
            byte[] bytes = new byte[1024];
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            int c = inputStream.read(bytes);
            while (c != -1) {
                OutputStream outputStream = this.outputStream;
                Intrinsics.checkNotNull((Object)outputStream);
                outputStream.write(bytes, 0, c);
                InputStream inputStream2 = this.inputStream;
                Intrinsics.checkNotNull((Object)inputStream2);
                c = inputStream2.read(bytes);
            }
            InputStream inputStream3 = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream3);
            inputStream3.close();
            OutputStream outputStream = this.outputStream;
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.close();
            boolean isDo = this.ftpClient.completePendingCommand();
            this.ftpClient.logout();
            this.ftpClient.disconnect();
            if (isDo) {
                if (file.renameTo(realFile)) {
                    this.log.info("ftp download successFull: " + localRealFile);
                    object = localRealFile;
                } else {
                    object = "";
                }
            } else {
                this.log.error("ftp download failed!");
                object = "";
            }
            String string8 = object;
            return string8;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.log.error("ftp download failed!");
            String string = "";
            return string;
        }
        finally {
            this.finallyFunc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doUpLoad(@Nullable File localFile) {
        boolean bl;
        try {
            if (localFile == null) {
                throw new FtpException("localFile is null");
            }
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new FtpException("fileName is null");
            }
            if (!this.connect()) {
                throw new FtpException("ftp server login failed!");
            }
            this.formatRemotePath();
            this.ftpClient.setControlEncoding(this.getCharset());
            String string = this.getRemotePath();
            Charset charset = Charset.forName(this.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Charset charset2 = Charset.forName(this.serverCharset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            this.setRemotePath(new String(byArray, charset2));
            String string2 = this.getFileName();
            Charset charset3 = Charset.forName(this.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(...)");
            byte[] byArray2 = string2.getBytes(charset3);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            Charset charset4 = Charset.forName(this.serverCharset);
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"forName(...)");
            this.setFileName(new String(byArray2, charset4));
            if (!this.ftpClient.changeWorkingDirectory(this.getRemotePath())) {
                if (StringsKt.startsWith$default((String)this.getRemotePath(), (String)"/", (boolean)false, (int)2, null)) {
                    String string3 = this.getRemotePath().substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    this.setRemotePath(string3);
                }
                this.createDirectory(this.getRemotePath());
            }
            boolean uploadResult = this.uploadFile(this.getFileName(), localFile);
            this.ftpClient.logout();
            this.ftpClient.disconnect();
            if (uploadResult) {
                this.log.info("ftp download successFull{" + localFile.getName() + "}: " + localFile.getCanonicalPath());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            bl = false;
        }
        finally {
            this.finallyFunc();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doDelete() {
        boolean bl;
        try {
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new FtpException("fileName is null");
            }
            if (!this.connect()) {
                throw new FtpException("ftp server login failed!");
            }
            this.formatRemotePath();
            String string = this.getRemotePath();
            Charset charset = Charset.forName(this.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Charset charset2 = Charset.forName(this.serverCharset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            this.setRemotePath(new String(byArray, charset2));
            String string2 = this.getFileName();
            Charset charset3 = Charset.forName(this.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(...)");
            byte[] byArray2 = string2.getBytes(charset3);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            Charset charset4 = Charset.forName(this.serverCharset);
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"forName(...)");
            this.setFileName(new String(byArray2, charset4));
            this.ftpClient.changeWorkingDirectory(this.getRemotePath());
            boolean result = true;
            FTPFile[] files = this.ftpClient.listFiles(this.getFileName());
            if (files.length == 1) {
                result = this.ftpClient.deleteFile(this.getFileName());
            }
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            bl = false;
        }
        finally {
            this.finallyFunc();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<FTPFile> getFileEntityList() {
        List list;
        try {
            if (!this.connect()) {
                throw new FtpException("ftp server login failed!");
            }
            this.formatRemotePath();
            String string = this.getRemotePath();
            Charset charset = Charset.forName(this.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Charset charset2 = Charset.forName(this.serverCharset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            this.setRemotePath(new String(byArray, charset2));
            this.ftpClient.changeWorkingDirectory(this.getRemotePath());
            this.ftpClient.listFiles();
            FTPFile[] fTPFileArray = this.ftpClient.listFiles(this.getRemotePath());
            Intrinsics.checkNotNullExpressionValue((Object)fTPFileArray, (String)"listFiles(...)");
            List fileList = ArraysKt.toList((Object[])fTPFileArray);
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        finally {
            this.finallyFunc();
        }
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AcpFtpConnectMode.values().length];
            try {
                nArray[AcpFtpConnectMode.ACTIVE_LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcpFtpConnectMode.ACTIVE_REMOTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcpFtpConnectMode.PASSIVE_LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcpFtpConnectMode.PASSIVE_REMOTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

