/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.ftp.client;

import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\"\u001a\u00020#H\u0004J\u001b\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010\u0019\u001a\u00020\u0003H\u0004\u00a2\u0006\u0002\u0010&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\rR\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\r\u00a8\u0006'"}, d2={"Lio/gitee/zhangbinhub/acp/boot/ftp/client/BaseClient;", "", "hostname", "", "port", "", "username", "password", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getHostname", "()Ljava/lang/String;", "setHostname", "(Ljava/lang/String;)V", "getPort", "()I", "setPort", "(I)V", "getUsername", "setUsername", "getPassword", "setPassword", "charset", "getCharset", "setCharset", "remotePath", "getRemotePath", "setRemotePath", "fileName", "getFileName", "setFileName", "localPath", "getLocalPath", "setLocalPath", "formatRemotePath", "", "parseCurrAndSubFold", "", "(Ljava/lang/String;)[Ljava/lang/String;", "acp-solon-boot-ftp"})
public abstract class BaseClient {
    @NotNull
    private String hostname;
    private int port;
    @NotNull
    private String username;
    @NotNull
    private String password;
    @NotNull
    private String charset;
    @NotNull
    private String remotePath;
    @NotNull
    private String fileName;
    @NotNull
    private String localPath;

    public BaseClient(@NotNull String hostname, int port, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.charset = CommonTools.getDefaultCharsetName();
        this.remotePath = "";
        this.fileName = "";
        this.localPath = "";
    }

    @NotNull
    public final String getHostname() {
        return this.hostname;
    }

    public final void setHostname(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.hostname = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.username = string;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    @NotNull
    public final String getCharset() {
        return this.charset;
    }

    public final void setCharset(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.charset = string;
    }

    @NotNull
    public final String getRemotePath() {
        return this.remotePath;
    }

    public final void setRemotePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.remotePath = string;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileName = string;
    }

    @NotNull
    public final String getLocalPath() {
        return this.localPath;
    }

    public final void setLocalPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.localPath = string;
    }

    protected final void formatRemotePath() {
        if (CommonTools.isNullStr((String)this.remotePath)) {
            this.remotePath = "/";
        } else {
            this.remotePath = StringsKt.replace$default((String)this.remotePath, (String)"\\", (String)"/", (boolean)false, (int)4, null) + "/";
            if (StringsKt.contains$default((CharSequence)this.remotePath, (CharSequence)"../", (boolean)false, (int)2, null)) {
                String string = this.remotePath.substring(StringsKt.lastIndexOf$default((CharSequence)this.remotePath, (String)"../", (int)0, (boolean)false, (int)6, null) + 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.remotePath = string;
            }
            if (StringsKt.contains$default((CharSequence)this.remotePath, (CharSequence)"./", (boolean)false, (int)2, null)) {
                String string = this.remotePath.substring(StringsKt.lastIndexOf$default((CharSequence)this.remotePath, (String)"../", (int)0, (boolean)false, (int)6, null) + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.remotePath = string;
            }
            if (!StringsKt.startsWith$default((String)this.remotePath, (String)"/", (boolean)false, (int)2, null)) {
                this.remotePath = "/" + this.remotePath;
            }
        }
    }

    @NotNull
    protected final String[] parseCurrAndSubFold(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String fold = null;
        String subFold = null;
        if (StringsKt.startsWith$default((String)remotePath, (String)"/", (boolean)false, (int)2, null)) {
            fold = "";
            String string = remotePath.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            subFold = string;
        } else if (StringsKt.contains$default((CharSequence)remotePath, (CharSequence)"/", (boolean)false, (int)2, null)) {
            int index = StringsKt.indexOf$default((CharSequence)remotePath, (String)"/", (int)0, (boolean)false, (int)6, null);
            String string = remotePath.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fold = string;
            String string2 = remotePath.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            subFold = string2;
        } else {
            fold = remotePath;
            subFold = "";
        }
        String[] stringArray = new String[]{fold, subFold};
        return stringArray;
    }
}

