/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.ftp.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import io.gitee.zhangbinhub.acp.boot.ftp.client.AcpSftpChannelMode;
import io.gitee.zhangbinhub.acp.boot.ftp.client.BaseClient;
import io.gitee.zhangbinhub.acp.boot.ftp.exceptions.SftpException;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tB1\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0003H\u0002J\b\u0010%\u001a\u00020!H\u0002J\u0006\u0010&\u001a\u00020\u0003J\u0010\u0010'\u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020+J\u0010\u0010-\u001a\f\u0012\b\u0012\u00060/R\u00020\u00120.R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpSftpClient;", "Lio/gitee/zhangbinhub/acp/boot/ftp/client/BaseClient;", "hostname", "", "port", "", "username", "password", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "keyFilePath", "passphrase", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "log", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "channel", "Lcom/jcraft/jsch/Channel;", "sftp", "Lcom/jcraft/jsch/ChannelSftp;", "session", "Lcom/jcraft/jsch/Session;", "serverCharset", "getServerCharset", "()Ljava/lang/String;", "setServerCharset", "(Ljava/lang/String;)V", "channelMode", "Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpSftpChannelMode;", "getChannelMode", "()Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpSftpChannelMode;", "setChannelMode", "(Lio/gitee/zhangbinhub/acp/boot/ftp/client/AcpSftpChannelMode;)V", "rebuildSftp", "", "connect", "createDirectory", "remotePath", "finallyFunc", "doDownLoad", "doUpload", "localFile", "Ljava/io/File;", "doDeleteDir", "", "doDeleteFile", "getFileEntityList", "", "Lcom/jcraft/jsch/ChannelSftp$LsEntry;", "acp-solon-boot-ftp"})
@SourceDebugExtension(value={"SMAP\nAcpSftpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpSftpClient.kt\nio/gitee/zhangbinhub/acp/boot/ftp/client/AcpSftpClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1557#2:300\n1628#2,3:301\n774#2:304\n865#2,2:305\n*S KotlinDebug\n*F\n+ 1 AcpSftpClient.kt\nio/gitee/zhangbinhub/acp/boot/ftp/client/AcpSftpClient\n*L\n290#1:300\n290#1:301,3\n291#1:304\n291#1:305,2\n*E\n"})
public final class AcpSftpClient
extends BaseClient {
    @NotNull
    private final LogFactory log;
    @Nullable
    private Channel channel;
    @Nullable
    private ChannelSftp sftp;
    @Nullable
    private Session session;
    @NotNull
    private String keyFilePath;
    @NotNull
    private String passphrase;
    @NotNull
    private String serverCharset;
    @NotNull
    private AcpSftpChannelMode channelMode;

    @NotNull
    public final String getServerCharset() {
        return this.serverCharset;
    }

    public final void setServerCharset(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverCharset = string;
    }

    @NotNull
    public final AcpSftpChannelMode getChannelMode() {
        return this.channelMode;
    }

    public final void setChannelMode(@NotNull AcpSftpChannelMode acpSftpChannelMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)acpSftpChannelMode), (String)"<set-?>");
        this.channelMode = acpSftpChannelMode;
    }

    public AcpSftpClient(@NotNull String hostname, int port, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        super(hostname, port, username, password);
        this.log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, this.getClass(), (int)0, (int)2, null);
        this.keyFilePath = "";
        this.passphrase = "";
        this.serverCharset = "GBK";
        this.channelMode = AcpSftpChannelMode.RESUME;
    }

    public AcpSftpClient(@NotNull String keyFilePath, @NotNull String passphrase, @NotNull String hostname, int port, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)keyFilePath, (String)"keyFilePath");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        super(hostname, port, username, "");
        this.log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, this.getClass(), (int)0, (int)2, null);
        this.keyFilePath = "";
        this.passphrase = "";
        this.serverCharset = "GBK";
        this.channelMode = AcpSftpChannelMode.RESUME;
        this.keyFilePath = keyFilePath;
        this.passphrase = passphrase;
    }

    private final void rebuildSftp() throws NoSuchFieldException, IllegalAccessException {
        block0: {
            ChannelSftp channelSftp = this.sftp;
            if (channelSftp == null) break block0;
            ChannelSftp it = channelSftp;
            boolean bl = false;
            Field field = it.getClass().getDeclaredField("server_version");
            field.setAccessible(true);
            field.set(this.sftp, 2);
        }
    }

    private final void connect() throws SftpException {
        try {
            JSch jsCh = new JSch();
            if (!CommonTools.isNullStr((String)this.keyFilePath)) {
                if (CommonTools.isNullStr((String)this.passphrase)) {
                    jsCh.addIdentity(this.keyFilePath);
                } else {
                    jsCh.addIdentity(this.keyFilePath, this.passphrase);
                }
                this.log.info("sftp connect,path of private key file\uff1a{" + this.keyFilePath + "}");
            }
            this.session = jsCh.getSession(this.getUsername(), this.getHostname(), this.getPort());
            if (!CommonTools.isNullStr((String)this.getPassword())) {
                Session session = this.session;
                Intrinsics.checkNotNull((Object)session);
                session.setPassword(this.getPassword());
            }
            Properties config = new Properties();
            ((Map)config).put("StrictHostKeyChecking", "no");
            Session session = this.session;
            Intrinsics.checkNotNull((Object)session);
            session.setConfig(config);
            Session session2 = this.session;
            Intrinsics.checkNotNull((Object)session2);
            session2.setDaemonThread(true);
            Session session3 = this.session;
            Intrinsics.checkNotNull((Object)session3);
            session3.connect();
            Session session4 = this.session;
            Intrinsics.checkNotNull((Object)session4);
            Channel channel = this.channel = session4.openChannel("sftp");
            Intrinsics.checkNotNull((Object)channel);
            channel.connect();
            this.sftp = (ChannelSftp)this.channel;
            this.rebuildSftp();
            ChannelSftp channelSftp = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp);
            channelSftp.setFilenameEncoding(this.serverCharset);
            String string = "sftp server hostname:[%s] port:[%s] is connect successFull";
            Object[] objectArray = new Object[]{this.getHostname(), this.getPort()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.log.info(string2);
        }
        catch (Exception e) {
            this.log.error("Cannot connect to specified sftp server : {" + this.getHostname() + "}:{" + this.getPort() + "} \n Exception message is: {" + e.getMessage() + "}");
            throw new SftpException(e.getMessage());
        }
    }

    private final void createDirectory(String remotePath) throws Exception {
        try {
            if (!CommonTools.isNullStr((String)remotePath)) {
                ChannelSftp channelSftp = this.sftp;
                Intrinsics.checkNotNull((Object)channelSftp);
                channelSftp.cd(remotePath);
            }
        }
        catch (SftpException e) {
            String[] tmpFold = this.parseCurrAndSubFold(remotePath);
            String fold = tmpFold[0];
            String subFold = tmpFold[1];
            if (!CommonTools.isNullStr((String)fold)) {
                try {
                    ChannelSftp channelSftp = this.sftp;
                    Intrinsics.checkNotNull((Object)channelSftp);
                    channelSftp.cd(fold);
                }
                catch (SftpException e1) {
                    ChannelSftp channelSftp = this.sftp;
                    Intrinsics.checkNotNull((Object)channelSftp);
                    channelSftp.mkdir(fold);
                    ChannelSftp channelSftp2 = this.sftp;
                    Intrinsics.checkNotNull((Object)channelSftp2);
                    channelSftp2.cd(fold);
                }
            }
            this.createDirectory(subFold);
        }
    }

    private final void finallyFunc() {
        block5: {
            ChannelSftp it;
            ChannelSftp channelSftp = this.sftp;
            if (channelSftp != null) {
                it = channelSftp;
                boolean bl = false;
                if (it.isConnected()) {
                    it.disconnect();
                }
                this.sftp = null;
            }
            Channel channel = this.channel;
            if (channel != null) {
                it = channel;
                boolean bl = false;
                if (it.isConnected()) {
                    it.disconnect();
                }
                this.channel = null;
            }
            Session session = this.session;
            if (session == null) break block5;
            it = session;
            boolean bl = false;
            if (it.isConnected()) {
                it.disconnect();
            }
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String doDownLoad() {
        try {
            Object object;
            if (CommonTools.isNullStr((String)this.getLocalPath())) {
                throw new SftpException("localPath is null");
            }
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new SftpException("fileName is null");
            }
            String string = this.getLocalPath();
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            String string3 = StringsKt.replace$default((String)string, (String)"\\", (String)string2, (boolean)false, (int)4, null);
            String string4 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"separator");
            String path = StringsKt.replace$default((String)string3, (String)"/", (String)string4, (boolean)false, (int)4, null);
            this.connect();
            this.formatRemotePath();
            String remoteFile = this.getRemotePath() + this.getFileName();
            String localFile = path + File.separator + this.getFileName() + ".tmp";
            String localRealFile = path + File.separator + this.getFileName();
            File realFile = new File(localRealFile);
            if (realFile.exists()) {
                this.log.info("sftp download successFull: " + localRealFile);
                String string5 = localRealFile;
                return string5;
            }
            File file = new File(localFile);
            ChannelSftp channelSftp = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp);
            channelSftp.get(remoteFile, localFile, null, this.channelMode.getValue());
            if (file.renameTo(realFile)) {
                this.log.info("sftp download successFull: " + localRealFile);
                object = localRealFile;
            } else {
                object = "";
            }
            String string6 = object;
            return string6;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.log.error("sftp download failed!");
            String string = "";
            return string;
        }
        finally {
            this.finallyFunc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doUpload(@Nullable File localFile) {
        try {
            if (localFile == null) {
                throw new SftpException("localFile is null");
            }
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new SftpException("fileName is null");
            }
            this.connect();
            this.formatRemotePath();
            try {
                ChannelSftp channelSftp = this.sftp;
                Intrinsics.checkNotNull((Object)channelSftp);
                channelSftp.cd(this.getRemotePath());
            }
            catch (SftpException e) {
                if (StringsKt.startsWith$default((String)this.getRemotePath(), (String)"/", (boolean)false, (int)2, null)) {
                    String string = this.getRemotePath().substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    this.setRemotePath(string);
                }
                this.createDirectory(this.getRemotePath());
            }
            ChannelSftp channelSftp = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp);
            channelSftp.put(localFile.getCanonicalPath(), this.getFileName(), 1);
            this.log.info("file:{" + localFile.getCanonicalPath() + "} is upload successful");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.finallyFunc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doDeleteDir() {
        boolean bl;
        try {
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new SftpException("fileName is null");
            }
            this.connect();
            this.formatRemotePath();
            ChannelSftp channelSftp = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp);
            channelSftp.cd(this.getRemotePath());
            ChannelSftp channelSftp2 = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp2);
            channelSftp2.rmdir(this.getFileName());
            bl = true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            bl = false;
        }
        finally {
            this.finallyFunc();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doDeleteFile() {
        boolean bl;
        try {
            if (CommonTools.isNullStr((String)this.getFileName())) {
                throw new SftpException("fileName is null");
            }
            this.connect();
            this.formatRemotePath();
            ChannelSftp channelSftp = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp);
            channelSftp.cd(this.getRemotePath());
            ChannelSftp channelSftp2 = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp2);
            channelSftp2.rm(this.getFileName());
            bl = true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            bl = false;
        }
        finally {
            this.finallyFunc();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChannelSftp.LsEntry> getFileEntityList() {
        List list;
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            this.connect();
            this.formatRemotePath();
            ChannelSftp channelSftp = this.sftp;
            Intrinsics.checkNotNull((Object)channelSftp);
            Vector vector = channelSftp.ls(this.getRemotePath());
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"ls(...)");
            Iterable $this$map$iv = vector;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void item;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp.LsEntry");
                collection.add((ChannelSftp.LsEntry)item);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ChannelSftp.LsEntry entity = (ChannelSftp.LsEntry)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{".", ".."};
                if (!(!CollectionsKt.listOf((Object[])objectArray).contains(entity.getFilename()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        finally {
            this.finallyFunc();
        }
        return list;
    }
}

