/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.ftp.server;

import io.gitee.zhangbinhub.acp.boot.ftp.conf.AcpFtpServerListenerConfiguration;
import io.gitee.zhangbinhub.acp.boot.ftp.exceptions.FtpServerException;
import io.gitee.zhangbinhub.acp.boot.ftp.server.AcpFtpServerUser;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.interfaces.IDaemonService;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import io.gitee.zhangbinhub.acp.core.common.security.Md5Encrypt;
import io.gitee.zhangbinhub.acp.core.common.security.SM3Encrypt;
import io.gitee.zhangbinhub.acp.core.common.security.Sha1Encrypt;
import io.gitee.zhangbinhub.acp.core.common.security.Sha256Encrypt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.impl.DefaultConnectionConfig;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitee/zhangbinhub/acp/boot/ftp/server/AcpFtpServer;", "Ljava/lang/Runnable;", "Lio/gitee/zhangbinhub/acp/core/common/interfaces/IDaemonService;", "userList", "", "Lio/gitee/zhangbinhub/acp/boot/ftp/server/AcpFtpServerUser;", "listen", "Lio/gitee/zhangbinhub/acp/boot/ftp/conf/AcpFtpServerListenerConfiguration;", "<init>", "(Ljava/util/List;Lio/gitee/zhangbinhub/acp/boot/ftp/conf/AcpFtpServerListenerConfiguration;)V", "log", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "ftpServerInstance", "Lorg/apache/ftpserver/FtpServer;", "getServiceName", "", "stopService", "", "run", "acp-solon-boot-ftp"})
public final class AcpFtpServer
implements Runnable,
IDaemonService {
    @NotNull
    private final List<AcpFtpServerUser> userList;
    @NotNull
    private final AcpFtpServerListenerConfiguration listen;
    @NotNull
    private final LogFactory log;
    @Nullable
    private FtpServer ftpServerInstance;

    public AcpFtpServer(@NotNull List<AcpFtpServerUser> userList, @NotNull AcpFtpServerListenerConfiguration listen) {
        Intrinsics.checkNotNullParameter(userList, (String)"userList");
        Intrinsics.checkNotNullParameter((Object)listen, (String)"listen");
        this.userList = userList;
        this.listen = listen;
        this.log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, this.getClass(), (int)0, (int)2, null);
    }

    @NotNull
    public String getServiceName() {
        return "ftp service " + this.listen.getName();
    }

    public void stopService() {
        block0: {
            FtpServer ftpServer = this.ftpServerInstance;
            if (ftpServer == null) break block0;
            ftpServer.stop();
        }
    }

    @Override
    public void run() {
        try {
            if (CommonTools.isNullStr((String)this.listen.getDefaultHomeDirectory())) {
                throw new Exception("defaultHomeDirectory is null");
            }
            String string = this.listen.getDefaultHomeDirectory();
            Intrinsics.checkNotNull((Object)string);
            String defaultHomeDirectory = string;
            FtpServerFactory serverFactory = new FtpServerFactory();
            ListenerFactory factory = new ListenerFactory();
            factory.setPort(this.listen.getPort());
            serverFactory.addListener("default", factory.createListener());
            DefaultConnectionConfig connectionConfig = new DefaultConnectionConfig(this.listen.getAnonymousLoginEnabled(), this.listen.getLoginFailureDelay(), this.listen.getMaxLogins(), this.listen.getMaxAnonymousLogins(), this.listen.getMaxLoginFailures(), this.listen.getMaxThreads());
            serverFactory.setConnectionConfig((ConnectionConfig)connectionConfig);
            String pwdMode = this.listen.getPwdEncryptMode();
            PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
            userManagerFactory.setPasswordEncryptor(new PasswordEncryptor(pwdMode){
                final /* synthetic */ String $pwdMode;
                {
                    this.$pwdMode = $pwdMode;
                }

                /*
                 * WARNING - bad return control flow
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public String encrypt(String pwd) {
                    String string;
                    block9: {
                        block8: {
                            Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
                            String string2 = this.$pwdMode;
                            switch (string2.hashCode()) {
                                case -1850268089: {
                                    if (!string2.equals("SHA256")) {
                                        return null;
                                    }
                                    break block8;
                                }
                                case 2543909: {
                                    if (string2.equals("SHA1")) break;
                                    return null;
                                }
                                case 82201: {
                                    if (!string2.equals("SM3")) {
                                        return null;
                                    }
                                    break block9;
                                }
                                case 76158: {
                                    if (!string2.equals("MD5")) return null;
                                    string = Md5Encrypt.encrypt$default((String)pwd, null, null, (int)6, null);
                                    return string;
                                }
                            }
                            string = Sha1Encrypt.encrypt$default((String)pwd, null, null, (int)6, null);
                            return string;
                        }
                        string = Sha256Encrypt.encrypt$default((String)pwd, null, null, (int)6, null);
                        return string;
                    }
                    string = SM3Encrypt.encrypt$default((String)pwd, null, null, (int)6, null);
                    return string;
                    return null;
                }

                public boolean matches(String passwordToCheck, String storedPassword) {
                    Intrinsics.checkNotNullParameter((Object)passwordToCheck, (String)"passwordToCheck");
                    Intrinsics.checkNotNullParameter((Object)storedPassword, (String)"storedPassword");
                    return Intrinsics.areEqual((Object)passwordToCheck, (Object)storedPassword);
                }
            });
            BaseUser anonymous = new BaseUser();
            anonymous.setName("anonymous");
            anonymous.setEnabled(this.listen.getAnonymousLoginEnabled());
            anonymous.setHomeDirectory(defaultHomeDirectory);
            if (this.listen.getAnonymousWritePermission()) {
                ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
                authorities.add(new WritePermission());
                anonymous.setAuthorities((List)authorities);
            }
            serverFactory.getUserManager().save((User)anonymous);
            if (!((Collection)this.userList).isEmpty()) {
                for (AcpFtpServerUser ftpServerUser : this.userList) {
                    BaseUser user = new BaseUser();
                    user.setName(ftpServerUser.getUsername());
                    user.setPassword(ftpServerUser.getPassword());
                    user.setEnabled(ftpServerUser.isEnableFlag());
                    Object homeDirectory = ftpServerUser.getHomeDirectory();
                    if (CommonTools.isNullStr((String)homeDirectory)) {
                        user.setHomeDirectory(defaultHomeDirectory);
                    } else {
                        if (!StringsKt.startsWith$default((String)(homeDirectory = StringsKt.replace$default((String)homeDirectory, (String)"\\", (String)"/", (boolean)false, (int)4, null)), (String)"/", (boolean)false, (int)2, null)) {
                            homeDirectory = "/" + (String)homeDirectory;
                        }
                        if (Intrinsics.areEqual((Object)defaultHomeDirectory, (Object)"/")) {
                            user.setHomeDirectory((String)homeDirectory);
                        } else {
                            user.setHomeDirectory(defaultHomeDirectory + (String)homeDirectory);
                        }
                    }
                    user.setMaxIdleTime(ftpServerUser.getIdleTime());
                    ArrayList<Object> authorities = new ArrayList<Object>();
                    if (ftpServerUser.getWritePermission()) {
                        authorities.add(new WritePermission());
                    }
                    authorities.add(new TransferRatePermission(ftpServerUser.getDownloadRate(), ftpServerUser.getUploadRate()));
                    authorities.add(new ConcurrentLoginPermission(ftpServerUser.getMaxLoginNumber(), ftpServerUser.getMaxLoginPerIp()));
                    user.setAuthorities((List)authorities);
                    serverFactory.getUserManager().save((User)user);
                }
            } else if (!this.listen.getAnonymousLoginEnabled()) {
                this.log.error("start ftp server failed [" + this.listen.getName() + "] : no user set!");
                throw new FtpServerException("no user set");
            }
            FtpServer ftpServer = this.ftpServerInstance = serverFactory.createServer();
            Intrinsics.checkNotNull((Object)ftpServer);
            ftpServer.start();
            this.log.info("ftp server [" + this.listen.getName() + "] is started, port : " + this.listen.getPort() + ", path : " + defaultHomeDirectory);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.log.error("start ftp server failed [" + this.listen.getName() + "] port:" + this.listen.getPort());
        }
    }
}

