/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.socket.tcp;

import io.gitee.zhangbinhub.acp.boot.log.LogAdapter;
import io.gitee.zhangbinhub.acp.boot.socket.base.SocketServerHandle;
import io.gitee.zhangbinhub.acp.boot.socket.conf.SocketListenerConfiguration;
import io.gitee.zhangbinhub.acp.boot.socket.tcp.TcpServerAdapter;
import io.gitee.zhangbinhub.acp.core.common.interfaces.IDaemonService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitee/zhangbinhub/acp/boot/socket/tcp/TcpServer;", "Lio/gitee/zhangbinhub/acp/core/common/interfaces/IDaemonService;", "Ljava/lang/Runnable;", "logAdapter", "Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;", "port", "", "socketListenerConfiguration", "Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;", "socketServerHandle", "Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;", "messageDecoder", "Lio/netty/handler/codec/ByteToMessageDecoder;", "<init>", "(Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;ILio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;Lio/netty/handler/codec/ByteToMessageDecoder;)V", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "workerGroup", "run", "", "getServiceName", "", "stopService", "acp-solon-boot-socket"})
public final class TcpServer
implements IDaemonService,
Runnable {
    @NotNull
    private final LogAdapter logAdapter;
    private final int port;
    @NotNull
    private final SocketListenerConfiguration socketListenerConfiguration;
    @Nullable
    private final SocketServerHandle socketServerHandle;
    @Nullable
    private final ByteToMessageDecoder messageDecoder;
    @NotNull
    private final EventLoopGroup bossGroup;
    @NotNull
    private final EventLoopGroup workerGroup;

    public TcpServer(@NotNull LogAdapter logAdapter, int port, @NotNull SocketListenerConfiguration socketListenerConfiguration, @Nullable SocketServerHandle socketServerHandle, @Nullable ByteToMessageDecoder messageDecoder) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
            Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"socketListenerConfiguration");
            this.logAdapter = logAdapter;
            this.port = port;
            this.socketListenerConfiguration = socketListenerConfiguration;
            this.socketServerHandle = socketServerHandle;
            this.messageDecoder = messageDecoder;
            this.bossGroup = (EventLoopGroup)new NioEventLoopGroup();
            this.workerGroup = (EventLoopGroup)new NioEventLoopGroup(this.socketListenerConfiguration.getThreadNumber());
            SocketServerHandle socketServerHandle2 = this.socketServerHandle;
            if (socketServerHandle2 == null) break block0;
            socketServerHandle2.setSocketListenerConfiguration(this.socketListenerConfiguration);
        }
    }

    @Override
    public void run() {
        if (this.socketServerHandle != null) {
            try {
                ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.socketListenerConfiguration.getKeepAlive()).childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
                    final /* synthetic */ TcpServer this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    protected void initChannel(Channel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ChannelHandler[] channelHandlerArray = ch.pipeline();
                        TcpServer tcpServer = this.this$0;
                        ChannelHandler[] $this$initChannel_u24lambda_u241 = channelHandlerArray;
                        boolean bl = false;
                        ByteToMessageDecoder byteToMessageDecoder = TcpServer.access$getMessageDecoder$p(tcpServer);
                        if (byteToMessageDecoder != null) {
                            ByteToMessageDecoder it = byteToMessageDecoder;
                            boolean bl2 = false;
                            ChannelHandler[] channelHandlerArray2 = new ChannelHandler[]{it};
                            $this$initChannel_u24lambda_u241.addLast(channelHandlerArray2);
                        }
                        ChannelHandler[] channelHandlerArray3 = new ChannelHandler[]{new IdleStateHandler(TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getReaderIdleTime(), TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getWriterIdleTime(), TcpServer.access$getSocketListenerConfiguration$p(tcpServer).getIdleTime(), TimeUnit.MILLISECONDS)};
                        $this$initChannel_u24lambda_u241.addLast(channelHandlerArray3);
                        ChannelHandler[] channelHandlerArray4 = channelHandlerArray;
                        channelHandlerArray = new ChannelHandler[]{new TcpServerAdapter(TcpServer.access$getLogAdapter$p(this.this$0), TcpServer.access$getSocketListenerConfiguration$p(this.this$0), TcpServer.access$getSocketServerHandle$p(this.this$0))};
                        channelHandlerArray4.addLast(channelHandlerArray);
                    }
                }).bind(this.port).sync().channel().closeFuture().sync();
            }
            catch (Exception e) {
                this.logAdapter.error(e.getMessage(), (Throwable)e);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.logAdapter.error("tcp listen server is stop,case by:response object is null[BaseSocketHandle]");
        }
    }

    @NotNull
    public String getServiceName() {
        return this.socketListenerConfiguration.getName();
    }

    public void stopService() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    public static final /* synthetic */ LogAdapter access$getLogAdapter$p(TcpServer $this) {
        return $this.logAdapter;
    }

    public static final /* synthetic */ SocketListenerConfiguration access$getSocketListenerConfiguration$p(TcpServer $this) {
        return $this.socketListenerConfiguration;
    }

    public static final /* synthetic */ SocketServerHandle access$getSocketServerHandle$p(TcpServer $this) {
        return $this.socketServerHandle;
    }

    public static final /* synthetic */ ByteToMessageDecoder access$getMessageDecoder$p(TcpServer $this) {
        return $this.messageDecoder;
    }
}

