/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.socket.base;

import io.gitee.zhangbinhub.acp.boot.log.LogAdapter;
import io.gitee.zhangbinhub.acp.boot.socket.base.SocketServerHandle;
import io.gitee.zhangbinhub.acp.boot.socket.conf.SocketListenerConfiguration;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J\"\u0010!\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\u001dH$J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lio/gitee/zhangbinhub/acp/boot/socket/base/BaseSocketServerAdapter;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "logAdapter", "Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;", "socketListenerConfiguration", "Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;", "socketServerHandle", "Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;", "<init>", "(Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;)V", "getLogAdapter", "()Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;", "getSocketListenerConfiguration", "()Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;", "setSocketListenerConfiguration", "(Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;)V", "getSocketServerHandle", "()Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;", "setSocketServerHandle", "(Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;)V", "channelRead", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "doResponse", "requestMsg", "responseStr", "", "beforeReadMessage", "Lio/netty/buffer/ByteBuf;", "afterReadMessage", "beforeSendMessage", "sendStr", "afterSendMessage", "exceptionCaught", "cause", "", "acp-solon-boot-socket"})
public abstract class BaseSocketServerAdapter
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final LogAdapter logAdapter;
    @NotNull
    private SocketListenerConfiguration socketListenerConfiguration;
    @NotNull
    private SocketServerHandle socketServerHandle;

    public BaseSocketServerAdapter(@NotNull LogAdapter logAdapter, @NotNull SocketListenerConfiguration socketListenerConfiguration, @NotNull SocketServerHandle socketServerHandle) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"socketListenerConfiguration");
        Intrinsics.checkNotNullParameter((Object)socketServerHandle, (String)"socketServerHandle");
        this.logAdapter = logAdapter;
        this.socketListenerConfiguration = socketListenerConfiguration;
        this.socketServerHandle = socketServerHandle;
    }

    @NotNull
    protected final LogAdapter getLogAdapter() {
        return this.logAdapter;
    }

    @NotNull
    protected final SocketListenerConfiguration getSocketListenerConfiguration() {
        return this.socketListenerConfiguration;
    }

    protected final void setSocketListenerConfiguration(@NotNull SocketListenerConfiguration socketListenerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"<set-?>");
        this.socketListenerConfiguration = socketListenerConfiguration;
    }

    @NotNull
    protected final SocketServerHandle getSocketServerHandle() {
        return this.socketServerHandle;
    }

    protected final void setSocketServerHandle(@NotNull SocketServerHandle socketServerHandle) {
        Intrinsics.checkNotNullParameter((Object)socketServerHandle, (String)"<set-?>");
        this.socketServerHandle = socketServerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            String string;
            ByteBuf byteBuf = this.beforeReadMessage(msg);
            if (this.socketListenerConfiguration.getHex()) {
                string = ByteBufUtil.hexDump((ByteBuf)byteBuf);
            } else {
                Charset charset = Charset.forName(this.socketListenerConfiguration.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                string = byteBuf.toString(charset);
            }
            String receiveStr = string;
            this.logAdapter.debug("socket receive:" + receiveStr);
            Intrinsics.checkNotNull((Object)receiveStr);
            String responseStr = this.socketServerHandle.doProcess(receiveStr);
            if (this.socketListenerConfiguration.getResponsible()) {
                responseStr = CommonTools.isNullStr((String)responseStr) ? "" : responseStr;
                try {
                    this.doResponse(ctx, msg, responseStr);
                    this.logAdapter.debug("socket return:" + responseStr);
                }
                catch (Exception e) {
                    this.logAdapter.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.logAdapter.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
            this.afterReadMessage(ctx);
        }
    }

    protected final void doResponse(@NotNull ChannelHandlerContext ctx, @Nullable Object requestMsg, @NotNull String responseStr) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)responseStr, (String)"responseStr");
        String retStr = responseStr;
        if (this.socketListenerConfiguration.getHex()) {
            byte[] bts = ByteBufUtil.decodeHexDump((CharSequence)responseStr);
            Intrinsics.checkNotNull((Object)bts);
            Charset charset = Charset.forName(this.socketListenerConfiguration.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            retStr = new String(bts, charset);
        }
        Object msgPackage = this.beforeSendMessage(ctx, requestMsg, retStr);
        ctx.writeAndFlush(msgPackage);
        this.afterSendMessage(ctx);
    }

    @NotNull
    protected abstract ByteBuf beforeReadMessage(@NotNull Object var1);

    protected abstract void afterReadMessage(@NotNull ChannelHandlerContext var1);

    @NotNull
    protected abstract Object beforeSendMessage(@NotNull ChannelHandlerContext var1, @Nullable Object var2, @NotNull String var3) throws Exception;

    protected abstract void afterSendMessage(@NotNull ChannelHandlerContext var1);

    @Deprecated(message="Deprecated in ChannelHandler")
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.logAdapter.debug(cause.getMessage(), cause);
        this.socketServerHandle.exceptionCaught(ctx, cause);
    }
}

