/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.socket.base;

import io.gitee.zhangbinhub.acp.boot.socket.base.SocketClientHandle;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0003J\u0018\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0018\u0010B\u001a\u00020<2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020DH\u0017J\r\u0010E\u001a\u00020<H \u00a2\u0006\u0002\bFJ\u0015\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020\u0003H \u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020<2\u0006\u0010\u001f\u001a\u00020 H \u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020M2\u0006\u0010A\u001a\u00020\u0012H \u00a2\u0006\u0002\bNJ\u0015\u0010O\u001a\u00020<2\u0006\u0010?\u001a\u00020@H \u00a2\u0006\u0002\bPJ\u0006\u0010Q\u001a\u00020<R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0005X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\n\"\u0004\b-\u0010\fR\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010(\u00a8\u0006R"}, d2={"Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketClient;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "serverIp", "", "port", "", "timeOut", "<init>", "(Ljava/lang/String;II)V", "getServerIp$acp_solon_boot_socket", "()Ljava/lang/String;", "setServerIp$acp_solon_boot_socket", "(Ljava/lang/String;)V", "getPort$acp_solon_boot_socket", "()I", "setPort$acp_solon_boot_socket", "(I)V", "lock", "", "log", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "getTimeOut", "setTimeOut", "maxTime", "getMaxTime", "group", "Lio/netty/channel/EventLoopGroup;", "getGroup", "()Lio/netty/channel/EventLoopGroup;", "setGroup", "(Lio/netty/channel/EventLoopGroup;)V", "channel", "Lio/netty/channel/Channel;", "getChannel", "()Lio/netty/channel/Channel;", "setChannel", "(Lio/netty/channel/Channel;)V", "hex", "", "getHex", "()Z", "setHex", "(Z)V", "serverCharset", "getServerCharset", "setServerCharset", "messageDecoder", "Lio/netty/handler/codec/ByteToMessageDecoder;", "getMessageDecoder", "()Lio/netty/handler/codec/ByteToMessageDecoder;", "setMessageDecoder", "(Lio/netty/handler/codec/ByteToMessageDecoder;)V", "socketHandle", "Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketClientHandle;", "getSocketHandle", "()Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketClientHandle;", "setSocketHandle", "(Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketClientHandle;)V", "isClosed", "doSend", "", "requestStr", "channelRead", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "exceptionCaught", "cause", "", "connect", "connect$acp_solon_boot_socket", "beforeSendMessage", "sendStr", "beforeSendMessage$acp_solon_boot_socket", "afterSendMessage", "afterSendMessage$acp_solon_boot_socket", "beforeReadMessage", "Lio/netty/buffer/ByteBuf;", "beforeReadMessage$acp_solon_boot_socket", "afterReadMessage", "afterReadMessage$acp_solon_boot_socket", "doClose", "acp-solon-boot-socket"})
public abstract class SocketClient
extends ChannelInboundHandlerAdapter {
    @NotNull
    private String serverIp;
    private int port;
    @NotNull
    private final Object lock;
    @NotNull
    private final LogFactory log;
    private int timeOut;
    private final int maxTime;
    @Nullable
    private EventLoopGroup group;
    @Nullable
    private Channel channel;
    private boolean hex;
    @NotNull
    private String serverCharset;
    @Nullable
    private ByteToMessageDecoder messageDecoder;
    @Nullable
    private SocketClientHandle socketHandle;

    public SocketClient(@NotNull String serverIp, int port, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)serverIp, (String)"serverIp");
        this.serverIp = serverIp;
        this.port = port;
        this.lock = new Object();
        this.log = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, ((Object)((Object)this)).getClass(), (int)0, (int)2, null);
        this.maxTime = 3600000;
        this.serverCharset = CommonTools.getDefaultCharsetName();
        this.timeOut = timeOut < this.maxTime ? timeOut : this.maxTime;
    }

    @NotNull
    public final String getServerIp$acp_solon_boot_socket() {
        return this.serverIp;
    }

    public final void setServerIp$acp_solon_boot_socket(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverIp = string;
    }

    public final int getPort$acp_solon_boot_socket() {
        return this.port;
    }

    public final void setPort$acp_solon_boot_socket(int n) {
        this.port = n;
    }

    protected final int getTimeOut() {
        return this.timeOut;
    }

    protected final void setTimeOut(int n) {
        this.timeOut = n;
    }

    protected final int getMaxTime() {
        return this.maxTime;
    }

    @Nullable
    protected final EventLoopGroup getGroup() {
        return this.group;
    }

    protected final void setGroup(@Nullable EventLoopGroup eventLoopGroup) {
        this.group = eventLoopGroup;
    }

    @Nullable
    protected final Channel getChannel() {
        return this.channel;
    }

    protected final void setChannel(@Nullable Channel channel) {
        this.channel = channel;
    }

    public final boolean getHex() {
        return this.hex;
    }

    public final void setHex(boolean bl) {
        this.hex = bl;
    }

    @NotNull
    public final String getServerCharset() {
        return this.serverCharset;
    }

    public final void setServerCharset(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverCharset = string;
    }

    @Nullable
    public final ByteToMessageDecoder getMessageDecoder() {
        return this.messageDecoder;
    }

    public final void setMessageDecoder(@Nullable ByteToMessageDecoder byteToMessageDecoder) {
        this.messageDecoder = byteToMessageDecoder;
    }

    @Nullable
    public final SocketClientHandle getSocketHandle() {
        return this.socketHandle;
    }

    public final void setSocketHandle(@Nullable SocketClientHandle socketClientHandle) {
        this.socketHandle = socketClientHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isClosed() {
        if (this.channel == null) return true;
        if (this.group == null) return true;
        Channel channel = this.channel;
        Intrinsics.checkNotNull((Object)channel);
        if (!channel.isOpen()) return true;
        EventLoopGroup eventLoopGroup = this.group;
        Intrinsics.checkNotNull((Object)eventLoopGroup);
        if (eventLoopGroup.isShuttingDown()) return true;
        EventLoopGroup eventLoopGroup2 = this.group;
        Intrinsics.checkNotNull((Object)eventLoopGroup2);
        if (eventLoopGroup2.isShutdown()) return true;
        EventLoopGroup eventLoopGroup3 = this.group;
        Intrinsics.checkNotNull((Object)eventLoopGroup3);
        if (!eventLoopGroup3.isTerminated()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSend(@NotNull String requestStr) {
        Intrinsics.checkNotNullParameter((Object)requestStr, (String)"requestStr");
        try {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (this.isClosed()) {
                    this.connect$acp_solon_boot_socket();
                }
                Unit unit = Unit.INSTANCE;
            }
            String sendStr = requestStr;
            if (this.hex) {
                byte[] bts = ByteBufUtil.decodeHexDump((CharSequence)sendStr);
                Intrinsics.checkNotNull((Object)bts);
                Charset charset = Charset.forName(this.serverCharset);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                sendStr = new String(bts, charset);
            }
            Object msgPack = this.beforeSendMessage$acp_solon_boot_socket(sendStr);
            Channel channel = this.channel;
            Intrinsics.checkNotNull((Object)channel);
            channel.writeAndFlush(msgPack);
            Channel channel2 = this.channel;
            Intrinsics.checkNotNull((Object)channel2);
            this.afterSendMessage$acp_solon_boot_socket(channel2);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            String string;
            ByteBuf byteBuf = this.beforeReadMessage$acp_solon_boot_socket(msg);
            if (this.hex) {
                string = ByteBufUtil.hexDump((ByteBuf)byteBuf);
            } else {
                Charset charset = Charset.forName(this.serverCharset);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                string = byteBuf.toString(charset);
            }
            String receiveStr = string;
            this.log.debug("socket receive:" + receiveStr);
            SocketClientHandle socketClientHandle = this.socketHandle;
            if (socketClientHandle != null) {
                Intrinsics.checkNotNull((Object)receiveStr);
                socketClientHandle.receiveMsg(receiveStr);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
            this.afterReadMessage$acp_solon_boot_socket(ctx);
        }
    }

    @Deprecated(message="Deprecated in ChannelHandler")
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.log.error(cause.getMessage(), cause);
        ctx.close();
    }

    public abstract void connect$acp_solon_boot_socket();

    @NotNull
    public abstract Object beforeSendMessage$acp_solon_boot_socket(@NotNull String var1) throws Exception;

    public abstract void afterSendMessage$acp_solon_boot_socket(@NotNull Channel var1);

    @NotNull
    public abstract ByteBuf beforeReadMessage$acp_solon_boot_socket(@NotNull Object var1);

    public abstract void afterReadMessage$acp_solon_boot_socket(@NotNull ChannelHandlerContext var1);

    public final void doClose() {
        block0: {
            EventLoopGroup eventLoopGroup = this.group;
            if (eventLoopGroup == null) break block0;
            eventLoopGroup.shutdownGracefully();
        }
    }
}

