/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.boot.socket.udp;

import io.gitee.zhangbinhub.acp.boot.log.LogAdapter;
import io.gitee.zhangbinhub.acp.boot.socket.base.BaseSocketServerAdapter;
import io.gitee.zhangbinhub.acp.boot.socket.base.SocketServerHandle;
import io.gitee.zhangbinhub.acp.boot.socket.conf.SocketListenerConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lio/gitee/zhangbinhub/acp/boot/socket/udp/UdpServerAdapter;", "Lio/gitee/zhangbinhub/acp/boot/socket/base/BaseSocketServerAdapter;", "logAdapter", "Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;", "socketListenerConfiguration", "Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;", "socketServerHandle", "Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;", "<init>", "(Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;Lio/gitee/zhangbinhub/acp/boot/socket/conf/SocketListenerConfiguration;Lio/gitee/zhangbinhub/acp/boot/socket/base/SocketServerHandle;)V", "beforeReadMessage", "Lio/netty/buffer/ByteBuf;", "msg", "", "afterSendMessage", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "afterReadMessage", "beforeSendMessage", "requestMsg", "sendStr", "", "acp-solon-boot-socket"})
public final class UdpServerAdapter
extends BaseSocketServerAdapter {
    public UdpServerAdapter(@NotNull LogAdapter logAdapter, @NotNull SocketListenerConfiguration socketListenerConfiguration, @NotNull SocketServerHandle socketServerHandle) {
        Intrinsics.checkNotNullParameter((Object)logAdapter, (String)"logAdapter");
        Intrinsics.checkNotNullParameter((Object)socketListenerConfiguration, (String)"socketListenerConfiguration");
        Intrinsics.checkNotNullParameter((Object)socketServerHandle, (String)"socketServerHandle");
        super(logAdapter, socketListenerConfiguration, socketServerHandle);
    }

    @Override
    @NotNull
    protected ByteBuf beforeReadMessage(@NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Object object = ((DatagramPacket)msg).content();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"content(...)");
        return (ByteBuf)object;
    }

    @Override
    protected void afterSendMessage(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    @Override
    protected void afterReadMessage(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    @Override
    @NotNull
    protected Object beforeSendMessage(@NotNull ChannelHandlerContext ctx, @Nullable Object requestMsg, @NotNull String sendStr) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)sendStr, (String)"sendStr");
        DatagramPacket packet = (DatagramPacket)requestMsg;
        Charset charset = Charset.forName(this.getSocketListenerConfiguration().getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = sendStr.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])byArray);
        DatagramPacket datagramPacket = packet;
        Intrinsics.checkNotNull((Object)datagramPacket);
        return new DatagramPacket(byteBuf, (InetSocketAddress)datagramPacket.sender());
    }
}

