/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud;

import io.gitee.zhangbinhub.acp.boot.AcpBootLogAutoConfiguration;
import io.gitee.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.gitee.zhangbinhub.acp.cloud.component.CloudTools;
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudLogServerClientConfiguration;
import io.gitee.zhangbinhub.acp.cloud.log.CloudLogAdapter;
import io.gitee.zhangbinhub.acp.cloud.log.LogInfo;
import io.gitee.zhangbinhub.acp.cloud.log.producer.LogBridge;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

@AutoConfiguration(before={AcpBootLogAutoConfiguration.class})
@ConditionalOnExpression(value="'${acp.cloud.log-server.client.enabled}'.equals('true')")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\r"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudLogAutoConfiguration;", "", "()V", "logAdapter", "Lio/gitee/zhangbinhub/acp/cloud/log/CloudLogAdapter;", "cloudTools", "Lio/gitee/zhangbinhub/acp/cloud/component/CloudTools;", "acpCloudLogServerClientConfiguration", "Lio/gitee/zhangbinhub/acp/cloud/conf/AcpCloudLogServerClientConfiguration;", "logBridge", "Lio/gitee/zhangbinhub/acp/cloud/log/producer/LogBridge;", "logInfo", "Lio/gitee/zhangbinhub/acp/cloud/log/LogInfo;", "acp-spring-cloud-starter"})
public class AcpCloudLogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LogAdapter.class})
    @NotNull
    public CloudLogAdapter logAdapter(@NotNull CloudTools cloudTools, @NotNull AcpCloudLogServerClientConfiguration acpCloudLogServerClientConfiguration, @NotNull LogBridge logBridge) {
        Intrinsics.checkNotNullParameter((Object)cloudTools, (String)"cloudTools");
        Intrinsics.checkNotNullParameter((Object)acpCloudLogServerClientConfiguration, (String)"acpCloudLogServerClientConfiguration");
        Intrinsics.checkNotNullParameter((Object)logBridge, (String)"logBridge");
        return new CloudLogAdapter(cloudTools, acpCloudLogServerClientConfiguration, logBridge);
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public LogInfo logInfo() {
        return new LogInfo();
    }
}

