/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gitee.zhangbinhub.acp.cloud.AcpCloudComponentAutoConfiguration;
import io.gitee.zhangbinhub.acp.cloud.log.LogInfo;
import io.gitee.zhangbinhub.acp.cloud.log.consumer.DefaultLogProcess;
import io.gitee.zhangbinhub.acp.cloud.log.consumer.LogProcess;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={BindingServiceConfiguration.class, AcpCloudComponentAutoConfiguration.class})
@ConditionalOnExpression(value="'${acp.cloud.log-server.enabled}'.equals('true')")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudLogServerAutoConfiguration;", "", "()V", "logFactory", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "logConsumer", "Lkotlin/Function1;", "", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "logProcess", "Lio/gitee/zhangbinhub/acp/cloud/log/consumer/LogProcess;", "acp-spring-cloud-starter"})
public class AcpCloudLogServerAutoConfiguration {
    @NotNull
    private final LogFactory logFactory = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, this.getClass(), (int)0, (int)2, null);

    @Bean
    @ConditionalOnMissingBean(value={LogProcess.class})
    @NotNull
    public LogProcess logProcess() {
        return new DefaultLogProcess();
    }

    @Bean(value={"logConsumer"})
    @ConditionalOnMissingBean(name={"logConsumer"})
    @NotNull
    public Function1<String, Unit> logConsumer(@NotNull ObjectMapper objectMapper, @NotNull LogProcess logProcess) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)logProcess, (String)"logProcess");
        return (Function1)new Function1<String, Unit>(objectMapper, logProcess, this){
            final /* synthetic */ ObjectMapper $objectMapper;
            final /* synthetic */ LogProcess $logProcess;
            final /* synthetic */ AcpCloudLogServerAutoConfiguration this$0;
            {
                this.$objectMapper = $objectMapper;
                this.$logProcess = $logProcess;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    Object object = this.$objectMapper.readValue(it, LogInfo.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                    LogInfo logInfo = (LogInfo)object;
                    String logType = "ALL";
                    if (!CommonTools.isNullStr((String)logInfo.getLogType())) {
                        logType = logInfo.getLogType();
                    }
                    logInfo.setLogType(logType);
                    this.$logProcess.process(logInfo);
                }
                catch (Exception e) {
                    AcpCloudLogServerAutoConfiguration.access$getLogFactory$p(this.this$0).error(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    public static final /* synthetic */ LogFactory access$getLogFactory$p(AcpCloudLogServerAutoConfiguration $this) {
        return $this.logFactory;
    }
}

