/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud;

import io.gitee.zhangbinhub.acp.boot.tools.EnvironmentTools;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudLogServerEnvironmentPostProcessor;", "Lorg/springframework/boot/env/EnvironmentPostProcessor;", "()V", "defaultDestination", "", "defaultGroupId", "defaultPropertiesName", "functionDefinitionProperties", "logConsumerBindName", "logServerClientEnabled", "logServerDestination", "logServerEnabled", "logServerGroupId", "overridePropertiesName", "postProcessEnvironment", "", "environment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "application", "Lorg/springframework/boot/SpringApplication;", "acp-spring-cloud-starter"})
public final class AcpCloudLogServerEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    @NotNull
    private final String overridePropertiesName;
    @NotNull
    private final String defaultPropertiesName;
    @NotNull
    private final String logServerEnabled;
    @NotNull
    private final String logServerClientEnabled;
    @NotNull
    private final String logServerDestination;
    @NotNull
    private final String logServerGroupId;
    @NotNull
    private final String functionDefinitionProperties;
    @NotNull
    private final String logConsumerBindName;
    @NotNull
    private final String defaultDestination;
    @NotNull
    private final String defaultGroupId;

    public AcpCloudLogServerEnvironmentPostProcessor() {
        this.overridePropertiesName = "acpCloudLogServerOverridesProperties";
        this.defaultPropertiesName = "acpCloudLogServerDefaultProperties";
        this.logServerEnabled = "acp.cloud.log-server.enabled";
        this.logServerClientEnabled = "acp.cloud.log-server.client.enabled";
        this.logServerDestination = "acp.cloud.log-server.destination";
        this.logServerGroupId = "acp.cloud.log-server.group-id";
        this.functionDefinitionProperties = "spring.cloud.function.definition";
        this.logConsumerBindName = "logConsumer-in-0";
        this.defaultDestination = "acp_cloud_log_server_message_topic";
        this.defaultGroupId = "acp_cloud_log_server_group";
    }

    public void postProcessEnvironment(@Nullable ConfigurableEnvironment environment, @Nullable SpringApplication application) {
        ConfigurableEnvironment configurableEnvironment = environment;
        Intrinsics.checkNotNull((Object)configurableEnvironment);
        if (configurableEnvironment.containsProperty(this.logServerEnabled) && StringsKt.equals((String)"true", (String)environment.getProperty(this.logServerEnabled), (boolean)true)) {
            Map overrides = new HashMap();
            Object definition = "logConsumer";
            if (environment.containsProperty(this.functionDefinitionProperties)) {
                String property = environment.getProperty(this.functionDefinitionProperties);
                if (property != null && StringsKt.contains$default((CharSequence)property, (CharSequence)((CharSequence)definition), (boolean)false, (int)2, null)) {
                    return;
                }
                definition = property + ";" + (String)definition;
            }
            overrides.put(this.functionDefinitionProperties, definition);
            MutablePropertySources mutablePropertySources = environment.getPropertySources();
            Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"getPropertySources(...)");
            EnvironmentTools.addOrReplaceProperty((MutablePropertySources)mutablePropertySources, (Map)overrides, (String)this.overridePropertiesName, (boolean)true);
            Map map = new HashMap();
            String prefix = "spring.cloud.stream";
            boolean bl = false;
            map.put(prefix + ".function.bindings." + this.logConsumerBindName, "acpLogServerInput");
            String destination = environment.getProperty(this.logServerDestination, this.defaultDestination);
            String groupId = environment.getProperty(this.logServerGroupId, this.defaultGroupId);
            String string = prefix + ".bindings.acpLogServerInput.destination";
            Intrinsics.checkNotNull((Object)destination);
            map.put(string, destination);
            map.put(prefix + ".bindings.acpLogServerInput.contentType", "application/json");
            String string2 = prefix + ".bindings.acpLogServerInput.group";
            Intrinsics.checkNotNull((Object)groupId);
            map.put(string2, groupId);
            MutablePropertySources mutablePropertySources2 = environment.getPropertySources();
            Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources2, (String)"getPropertySources(...)");
            EnvironmentTools.addOrReplaceProperty((MutablePropertySources)mutablePropertySources2, (Map)map, (String)this.defaultPropertiesName, (boolean)false);
        }
        if (environment.containsProperty(this.logServerClientEnabled) && StringsKt.equals((String)"true", (String)environment.getProperty(this.logServerClientEnabled), (boolean)true)) {
            Map map = new HashMap();
            String prefix = "spring.cloud.stream";
            boolean bl = false;
            String destination = environment.getProperty(this.logServerDestination, this.defaultDestination);
            String string = prefix + ".bindings.acpLogServerOutput.destination";
            Intrinsics.checkNotNull((Object)destination);
            map.put(string, destination);
            map.put(prefix + ".bindings.acpLogServerOutput.contentType", "application/json");
            MutablePropertySources mutablePropertySources = environment.getPropertySources();
            Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"getPropertySources(...)");
            EnvironmentTools.addOrReplaceProperty((MutablePropertySources)mutablePropertySources, (Map)map, (String)this.defaultPropertiesName, (boolean)false);
        }
    }
}

