/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud.aspect;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gitee.zhangbinhub.acp.boot.exceptions.WebException;
import io.gitee.zhangbinhub.acp.cloud.annotation.AcpCloudDuplicateSubmission;
import io.gitee.zhangbinhub.acp.cloud.lock.DistributedLock;
import io.gitee.zhangbinhub.acp.core.common.security.Md5Encrypt;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483648)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007J+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/aspect/RestControllerRepeatAspect;", "", "distributedLock", "Lio/gitee/zhangbinhub/acp/cloud/lock/DistributedLock;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lio/gitee/zhangbinhub/acp/cloud/lock/DistributedLock;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "doAround", "pjp", "Lorg/aspectj/lang/ProceedingJoinPoint;", "executeService", "", "getKey", "", "prefix", "keyExpress", "args", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "acp-spring-cloud-starter"})
public final class RestControllerRepeatAspect {
    @NotNull
    private final DistributedLock distributedLock;
    @NotNull
    private final ObjectMapper objectMapper;

    public RestControllerRepeatAspect(@NotNull DistributedLock distributedLock, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)distributedLock, (String)"distributedLock");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.distributedLock = distributedLock;
        this.objectMapper = objectMapper;
    }

    @Pointcut(value="execution(public * *(..)) && @annotation(io.gitee.zhangbinhub.acp.cloud.annotation.AcpCloudDuplicateSubmission)")
    public final void executeService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="executeService()")
    @Nullable
    public final Object doAround(@NotNull ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        Intrinsics.checkNotNullParameter((Object)pjp, (String)"pjp");
        Signature signature = pjp.getSignature();
        Intrinsics.checkNotNull((Object)signature, (String)"null cannot be cast to non-null type org.aspectj.lang.reflect.MethodSignature");
        MethodSignature signature2 = (MethodSignature)signature;
        Method method = signature2.getMethod();
        AcpCloudDuplicateSubmission duplicateSubmission = method.getAnnotation(AcpCloudDuplicateSubmission.class);
        String string = signature2.getDeclaringTypeName() + "." + method.getName();
        String string2 = duplicateSubmission.keyExpress();
        Object[] objectArray = pjp.getArgs();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getArgs(...)");
        String key = this.getKey(string, string2, objectArray);
        long expire = duplicateSubmission.expire();
        if (this.distributedLock.getLock(key, key, expire, false)) {
            try {
                object = pjp.proceed();
            }
            finally {
                this.distributedLock.releaseLock(key, key);
            }
        } else {
            throw new WebException("\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42");
        }
        return object;
    }

    private final String getKey(String prefix, String keyExpress, Object[] args) {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse) continue;
            builder.append(",");
            if (arg instanceof Integer || arg instanceof Long || arg instanceof Float || arg instanceof Double || arg instanceof Boolean || arg instanceof String || arg instanceof Character || arg instanceof Byte) {
                builder.append(arg.toString());
                continue;
            }
            try {
                builder.append(this.objectMapper.writeValueAsString(arg));
            }
            catch (JsonProcessingException e) {
                builder.append(arg.toString());
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String keyValue = prefix + ":" + Md5Encrypt.encrypt$default((String)string, null, null, (int)6, null);
        return StringsKt.replace$default((String)keyExpress, (String)"[key]", (String)keyValue, (boolean)false, (int)4, null);
    }
}

