/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud.component;

import io.gitee.zhangbinhub.acp.boot.component.ServerTools;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.commons.util.InetUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/component/CloudTools;", "", "serverTools", "Lio/gitee/zhangbinhub/acp/boot/component/ServerTools;", "inetUtils", "Lorg/springframework/cloud/commons/util/InetUtils;", "(Lio/gitee/zhangbinhub/acp/boot/component/ServerTools;Lorg/springframework/cloud/commons/util/InetUtils;)V", "ip", "", "getServerIp", "getServerPort", "", "acp-spring-cloud-starter"})
public final class CloudTools {
    @NotNull
    private final ServerTools serverTools;
    @NotNull
    private final InetUtils inetUtils;
    @Value(value="${server.address:}")
    @Nullable
    private String ip;

    public CloudTools(@NotNull ServerTools serverTools, @NotNull InetUtils inetUtils) {
        Intrinsics.checkNotNullParameter((Object)serverTools, (String)"serverTools");
        Intrinsics.checkNotNullParameter((Object)inetUtils, (String)"inetUtils");
        this.serverTools = serverTools;
        this.inetUtils = inetUtils;
    }

    public final int getServerPort() {
        return this.serverTools.getServerPort();
    }

    @NotNull
    public final String getServerIp() {
        String string;
        if (CommonTools.isNullStr((String)this.ip)) {
            String string2;
            try {
                String string3 = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                if (string3 == null) {
                    string3 = this.serverTools.getServerIp();
                }
                string2 = string3;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                string2 = "";
            }
            string = string2;
        } else {
            String string4 = this.ip;
            string = string4;
            Intrinsics.checkNotNull((Object)string4);
        }
        return string;
    }
}

