/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gitee.zhangbinhub.acp.boot.interfaces.LogAdapter;
import io.gitee.zhangbinhub.acp.boot.tools.SpringBeanFactory;
import io.gitee.zhangbinhub.acp.cloud.component.CloudTools;
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudLogServerClientConfiguration;
import io.gitee.zhangbinhub.acp.cloud.log.LogInfo;
import io.gitee.zhangbinhub.acp.cloud.log.producer.LogBridge;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import io.gitee.zhangbinhub.acp.core.common.task.BaseAsyncTask;
import io.gitee.zhangbinhub.acp.core.common.task.threadpool.ThreadPoolService;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J/\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J/\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0019\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J/\u0010\u0019\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0019\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0012\u0010\u001e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J/\u0010\u001e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u001e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u001f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J/\u0010\u001f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u001f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/gitee/zhangbinhub/acp/cloud/log/CloudLogAdapter;", "Lio/gitee/zhangbinhub/acp/boot/interfaces/LogAdapter;", "cloudTools", "Lio/gitee/zhangbinhub/acp/cloud/component/CloudTools;", "acpCloudLogServerClientConfiguration", "Lio/gitee/zhangbinhub/acp/cloud/conf/AcpCloudLogServerClientConfiguration;", "logBridge", "Lio/gitee/zhangbinhub/acp/cloud/log/producer/LogBridge;", "(Lio/gitee/zhangbinhub/acp/cloud/component/CloudTools;Lio/gitee/zhangbinhub/acp/cloud/conf/AcpCloudLogServerClientConfiguration;Lio/gitee/zhangbinhub/acp/cloud/log/producer/LogBridge;)V", "stackIndex", "", "debug", "", "message", "", "variable", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "error", "generateLogInfo", "Lio/gitee/zhangbinhub/acp/cloud/log/LogInfo;", "logLevel", "info", "logInstance", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "sendToLogServer", "logInfo", "trace", "warn", "acp-spring-cloud-starter"})
public final class CloudLogAdapter
implements LogAdapter {
    @NotNull
    private final CloudTools cloudTools;
    @NotNull
    private final AcpCloudLogServerClientConfiguration acpCloudLogServerClientConfiguration;
    @NotNull
    private final LogBridge logBridge;
    private final int stackIndex;

    public CloudLogAdapter(@NotNull CloudTools cloudTools, @NotNull AcpCloudLogServerClientConfiguration acpCloudLogServerClientConfiguration, @NotNull LogBridge logBridge) {
        Intrinsics.checkNotNullParameter((Object)cloudTools, (String)"cloudTools");
        Intrinsics.checkNotNullParameter((Object)acpCloudLogServerClientConfiguration, (String)"acpCloudLogServerClientConfiguration");
        Intrinsics.checkNotNullParameter((Object)logBridge, (String)"logBridge");
        this.cloudTools = cloudTools;
        this.acpCloudLogServerClientConfiguration = acpCloudLogServerClientConfiguration;
        this.logBridge = logBridge;
        this.stackIndex = 4;
    }

    private final LogFactory logInstance() {
        String string = Thread.currentThread().getStackTrace()[this.stackIndex - 1].getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        return LogFactory.Companion.getInstance(string, this.stackIndex);
    }

    private final LogInfo generateLogInfo(String logLevel, String message) {
        LogInfo logInfo;
        LogInfo logInfo2 = (LogInfo)SpringBeanFactory.Companion.getBean(LogInfo.class);
        if (logInfo2 != null) {
            LogInfo logInfo3;
            LogInfo $this$generateLogInfo_u24lambda_u240 = logInfo3 = logInfo2;
            boolean bl = false;
            String logType = this.acpCloudLogServerClientConfiguration.getLogType();
            if (CommonTools.isNullStr((String)logType)) {
                logType = "ALL";
            }
            $this$generateLogInfo_u24lambda_u240.setLogType(logType);
            $this$generateLogInfo_u24lambda_u240.setServerIp(this.cloudTools.getServerIp());
            $this$generateLogInfo_u24lambda_u240.setServerPort(this.cloudTools.getServerPort());
            $this$generateLogInfo_u24lambda_u240.setTraceId(MDC.get((String)"traceId"));
            $this$generateLogInfo_u24lambda_u240.setSpanId(MDC.get((String)"traceId"));
            $this$generateLogInfo_u24lambda_u240.setLogLevel$acp_spring_cloud_starter(logLevel);
            $this$generateLogInfo_u24lambda_u240.setMessage$acp_spring_cloud_starter(message);
            logInfo = logInfo3;
        } else {
            logInfo = null;
        }
        return logInfo;
    }

    private final void sendToLogServer(LogInfo logInfo) {
        if (this.acpCloudLogServerClientConfiguration.getEnabled()) {
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            ThreadPoolService threadPoolService = ThreadPoolService.Companion.getInstance$default((ThreadPoolService.Companion)ThreadPoolService.Companion, (int)1, (int)1, (int)Integer.MAX_VALUE, (String)"cloud_log_adapter_thread_pool", (long)0L, (int)16, null);
            threadPoolService.addTask(new BaseAsyncTask(logInfo, stacks, this){
                final /* synthetic */ LogInfo $logInfo;
                final /* synthetic */ StackTraceElement[] $stacks;
                final /* synthetic */ CloudLogAdapter this$0;
                {
                    this.$logInfo = $logInfo;
                    this.$stacks = $stacks;
                    this.this$0 = $receiver;
                    super("cloud_log_adapter_thread_task", false);
                }

                public boolean beforeExecuteFun() {
                    return true;
                }

                public void afterExecuteFun(@NotNull Object result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                }

                @NotNull
                public Object executeFun() {
                    this.$logInfo.setServerTime(CommonTools.getNowDateTime().toDate().getTime());
                    this.$logInfo.setLineNo(this.$stacks[CloudLogAdapter.access$getStackIndex$p(this.this$0) - 1].getLineNumber());
                    this.$logInfo.setClassName(this.$stacks[CloudLogAdapter.access$getStackIndex$p(this.this$0) - 1].getClassName());
                    try {
                        CloudLogAdapter.access$getLogBridge$p(this.this$0).send(this.$logInfo);
                    }
                    catch (JsonProcessingException e) {
                        CloudLogAdapter.access$logInstance(this.this$0).error(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }
            });
        }
    }

    public void info(@Nullable String message) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.info(message);
            if (!log.isInfoEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Info", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void info(@Nullable String message, Object ... variable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.info(message, Arrays.copyOf(variable, variable.length));
            if (!log.isInfoEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Info", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                it.setParams$acp_spring_cloud_starter(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(variable, variable.length)));
                this.sendToLogServer(it);
            }
        }
    }

    public void info(@Nullable String message, @Nullable Throwable t) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.info(message, t);
            if (!log.isInfoEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Info", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void debug(@Nullable String message) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.debug(message);
            if (!log.isDebugEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Debug", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void debug(@Nullable String message, Object ... variable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.debug(message, Arrays.copyOf(variable, variable.length));
            if (!log.isDebugEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Debug", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                it.setParams$acp_spring_cloud_starter(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(variable, variable.length)));
                this.sendToLogServer(it);
            }
        }
    }

    public void debug(@Nullable String message, @Nullable Throwable t) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.debug(message, t);
            if (!log.isDebugEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Debug", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void warn(@Nullable String message) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.warn(message);
            if (!log.isWarnEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Warn", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void warn(@Nullable String message, Object ... variable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.warn(message, Arrays.copyOf(variable, variable.length));
            if (!log.isWarnEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Warn", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                it.setParams$acp_spring_cloud_starter(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(variable, variable.length)));
                this.sendToLogServer(it);
            }
        }
    }

    public void warn(@Nullable String message, @Nullable Throwable t) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.warn(message, t);
            if (!log.isWarnEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Warn", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void error(@Nullable String message) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.error(message);
            if (!log.isErrorEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Error", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void error(@Nullable String message, Object ... variable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.error(message, Arrays.copyOf(variable, variable.length));
            if (!log.isErrorEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Error", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                it.setParams$acp_spring_cloud_starter(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(variable, variable.length)));
                this.sendToLogServer(it);
            }
        }
    }

    public void error(@Nullable String message, @Nullable Throwable t) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.error(message, t);
            if (!log.isErrorEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Error", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void trace(@Nullable String message) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.trace(message);
            if (!log.isTraceEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Trace", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public void trace(@Nullable String message, Object ... variable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.trace(message, Arrays.copyOf(variable, variable.length));
            if (!log.isTraceEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Trace", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                it.setParams$acp_spring_cloud_starter(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(variable, variable.length)));
                this.sendToLogServer(it);
            }
        }
    }

    public void trace(@Nullable String message, @Nullable Throwable t) {
        block1: {
            LogFactory log = this.logInstance();
            boolean bl = false;
            log.trace(message, t);
            if (!log.isTraceEnabled()) break block1;
            LogInfo logInfo = this.generateLogInfo("Trace", message);
            if (logInfo != null) {
                LogInfo it = logInfo;
                boolean bl2 = false;
                this.sendToLogServer(it);
            }
        }
    }

    public static final /* synthetic */ int access$getStackIndex$p(CloudLogAdapter $this) {
        return $this.stackIndex;
    }

    public static final /* synthetic */ LogBridge access$getLogBridge$p(CloudLogAdapter $this) {
        return $this.logBridge;
    }

    public static final /* synthetic */ LogFactory access$logInstance(CloudLogAdapter $this) {
        return $this.logInstance();
    }
}

