/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud.log.consumer;

import io.gitee.zhangbinhub.acp.cloud.enums.LogLevel;
import io.gitee.zhangbinhub.acp.cloud.log.LogInfo;
import io.gitee.zhangbinhub.acp.cloud.log.consumer.LogProcess;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.exceptions.EnumValueUndefinedException;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import io.gitee.zhangbinhub.acp.core.common.task.BaseAsyncTask;
import io.gitee.zhangbinhub.acp.core.common.task.threadpool.ThreadPoolService;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/log/consumer/DefaultLogProcess;", "Lio/gitee/zhangbinhub/acp/cloud/log/consumer/LogProcess;", "()V", "doLog", "", "logInfo", "Lio/gitee/zhangbinhub/acp/cloud/log/LogInfo;", "process", "acp-spring-cloud-starter"})
@SourceDebugExtension(value={"SMAP\nDefaultLogProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLogProcess.kt\nio/gitee/zhangbinhub/acp/cloud/log/consumer/DefaultLogProcess\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n37#2,2:97\n37#2,2:99\n37#2,2:101\n37#2,2:103\n37#2,2:105\n*S KotlinDebug\n*F\n+ 1 DefaultLogProcess.kt\nio/gitee/zhangbinhub/acp/cloud/log/consumer/DefaultLogProcess\n*L\n55#1:97,2\n63#1:99,2\n71#1:101,2\n79#1:103,2\n87#1:105,2\n*E\n"})
public final class DefaultLogProcess
implements LogProcess {
    @Override
    public void process(@NotNull LogInfo logInfo) {
        Intrinsics.checkNotNullParameter((Object)logInfo, (String)"logInfo");
        ThreadPoolService threadPoolService = ThreadPoolService.Companion.getInstance$default((ThreadPoolService.Companion)ThreadPoolService.Companion, (int)1, (int)1, (int)Integer.MAX_VALUE, (String)(logInfo.getLogType() + "_log"), (long)0L, (int)16, null);
        String string = logInfo.getLogType() + "_log";
        threadPoolService.addTask(new BaseAsyncTask(this, logInfo, string){
            final /* synthetic */ DefaultLogProcess this$0;
            final /* synthetic */ LogInfo $logInfo;
            {
                this.this$0 = $receiver;
                this.$logInfo = $logInfo;
                super($super_call_param$1, false);
            }

            public boolean beforeExecuteFun() {
                return true;
            }

            @NotNull
            public Object executeFun() {
                DefaultLogProcess.access$doLog(this.this$0, this.$logInfo);
                return true;
            }

            public void afterExecuteFun(@NotNull Object result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            }
        });
    }

    private final void doLog(LogInfo logInfo) {
        LogLevel logLevel;
        LogFactory logFactory = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, (String)logInfo.getLogType(), (int)0, (int)2, null);
        try {
            String string = logInfo.getLogLevel();
            Intrinsics.checkNotNull((Object)string);
            logLevel = LogLevel.Companion.getEnum(string);
        }
        catch (EnumValueUndefinedException e) {
            logFactory.error(e.getMessage(), (Throwable)e);
            logLevel = LogLevel.Other;
        }
        LogLevel logLevel2 = logLevel;
        StringBuilder stringBuilder = new StringBuilder().append("[ ").append(CommonTools.strFillIn((String)logLevel2.name(), (int)5, (int)1, (char)' ')).append(" ] ").append("[");
        String string = logInfo.getServerName();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("] ").append("[ip:");
        String string2 = logInfo.getServerIp();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("] ").append("[port:");
        Object object = logInfo.getServerPort();
        if (object == null) {
            object = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append("] ").append("[");
        String string3 = logInfo.getClassName();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string3).append("] ").append("[").append(logInfo.getLineNo()).append("] ").append("[traceId:");
        String string4 = logInfo.getTraceId();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder6 = stringBuilder5.append(string4).append("] ").append("[spanId:");
        String string5 = logInfo.getSpanId();
        if (string5 == null) {
            string5 = "";
        }
        StringBuilder stringBuilder7 = stringBuilder6.append(string5).append("] - ");
        String string6 = logInfo.getMessage();
        if (string6 == null) {
            string6 = "";
        }
        StringBuilder message = stringBuilder7.append(string6);
        switch (WhenMappings.$EnumSwitchMapping$0[logLevel2.ordinal()]) {
            case 1: {
                if (!((Collection)logInfo.getParams()).isEmpty()) {
                    Collection $this$toTypedArray$iv = logInfo.getParams();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    logFactory.debug(message.toString(), Arrays.copyOf(objectArray, objectArray.length));
                    break;
                }
                logFactory.debug(message.toString());
                break;
            }
            case 2: {
                if (!((Collection)logInfo.getParams()).isEmpty()) {
                    Collection $this$toTypedArray$iv = logInfo.getParams();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    logFactory.warn(message.toString(), Arrays.copyOf(objectArray, objectArray.length));
                    break;
                }
                logFactory.warn(message.toString());
                break;
            }
            case 3: {
                if (!((Collection)logInfo.getParams()).isEmpty()) {
                    Collection $this$toTypedArray$iv = logInfo.getParams();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    logFactory.error(message.toString(), Arrays.copyOf(objectArray, objectArray.length));
                    break;
                }
                logFactory.error(message.toString());
                break;
            }
            case 4: {
                if (!((Collection)logInfo.getParams()).isEmpty()) {
                    Collection $this$toTypedArray$iv = logInfo.getParams();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    logFactory.trace(message.toString(), Arrays.copyOf(objectArray, objectArray.length));
                    break;
                }
                logFactory.trace(message.toString());
                break;
            }
            default: {
                if (!((Collection)logInfo.getParams()).isEmpty()) {
                    Collection $this$toTypedArray$iv = logInfo.getParams();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    logFactory.info(message.toString(), Arrays.copyOf(objectArray, objectArray.length));
                    break;
                }
                logFactory.info(message.toString());
            }
        }
    }

    public static final /* synthetic */ void access$doLog(DefaultLogProcess $this, LogInfo logInfo) {
        $this.doLog(logInfo);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.Debug.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Warn.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Trace.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

