package io.gitee.zhangbinhub.acp.cloud

import com.fasterxml.jackson.databind.ObjectMapper
import io.gitee.zhangbinhub.acp.boot.AcpComponentAutoConfiguration
import io.gitee.zhangbinhub.acp.boot.tools.ServerTools
import io.gitee.zhangbinhub.acp.cloud.aspect.RestControllerRepeatAspect
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudTransmitHeaderConfiguration
import io.gitee.zhangbinhub.acp.cloud.lock.DistributedLock
import io.gitee.zhangbinhub.acp.cloud.tools.CloudTools
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean
import org.springframework.cloud.commons.util.InetUtils
import org.springframework.context.annotation.Bean

/**
 * @since JDK 17
 */
@AutoConfiguration(after = [AcpComponentAutoConfiguration::class])
class AcpCloudComponentAutoConfiguration {
    @Bean
    @ConditionalOnBean(DistributedLock::class)
    fun restControllerRepeatAspect(
        distributedLock: DistributedLock,
        objectMapper: ObjectMapper
    ) = RestControllerRepeatAspect(distributedLock, objectMapper)

    @Bean
    fun cloudTools(
        acpCloudTransmitHeaderConfiguration: AcpCloudTransmitHeaderConfiguration,
        serverTools: ServerTools,
        inetUtils: InetUtils
    ) = CloudTools(acpCloudTransmitHeaderConfiguration, serverTools, inetUtils)
}
