package io.gitee.zhangbinhub.acp.cloud

import feign.Feign
import feign.RequestInterceptor
import io.gitee.zhangbinhub.acp.cloud.tools.CloudTools
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Primary

/**
 * @date 2020-12-31
 */
@AutoConfiguration
@ConditionalOnClass(Feign::class)
class AcpCloudFeignAutoConfiguration {

    /**
     * 自定义 Feign 请求拦截器，请求之前将 header 中的属性传入 Request 的 header
     *
     * @return 自定义 Feign 请求拦截器实例
     */
    @Primary
    @Bean
    fun requestInterceptor(cloudTools: CloudTools): RequestInterceptor {
        return RequestInterceptor { requestTemplate ->
            cloudTools.transmitHeadersFeign(requestTemplate)
        }
    }
}
