package io.gitee.zhangbinhub.acp.cloud

import io.gitee.zhangbinhub.acp.boot.AcpBootLogAutoConfiguration
import io.gitee.zhangbinhub.acp.boot.log.LogAdapter
import io.gitee.zhangbinhub.acp.cloud.tools.CloudTools
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudLogServerClientConfiguration
import io.gitee.zhangbinhub.acp.cloud.component.CloudLogAdapter
import io.gitee.zhangbinhub.acp.cloud.log.AcpCloudLogInfo
import io.gitee.zhangbinhub.acp.cloud.log.producer.LogBridge
import org.springframework.beans.factory.config.ConfigurableBeanFactory
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Scope

/**
 * @since JDK 17
 */
@AutoConfiguration(before = [AcpBootLogAutoConfiguration::class])
@ConditionalOnExpression("'\${acp.cloud.log-server.client.enabled}'.equals('true')")
class AcpCloudLogAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(LogAdapter::class)
    fun logAdapter(
        cloudTools: CloudTools,
        acpCloudLogServerClientConfiguration: AcpCloudLogServerClientConfiguration,
        logBridge: LogBridge
    ): LogAdapter = CloudLogAdapter(cloudTools, acpCloudLogServerClientConfiguration, logBridge)

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    fun cloudLogInfo() = AcpCloudLogInfo()
}