package io.gitee.zhangbinhub.acp.cloud

import com.fasterxml.jackson.databind.ObjectMapper
import io.gitee.zhangbinhub.acp.cloud.constant.AcpCloudLogConstant
import io.gitee.zhangbinhub.acp.cloud.log.producer.LogBridge
import io.gitee.zhangbinhub.acp.cloud.log.producer.StreamLogBridge
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.cloud.stream.config.BindingServiceConfiguration
import org.springframework.cloud.stream.function.StreamBridge
import org.springframework.context.annotation.Bean

/**
 * 日志服务客户端自动配置
 *
 * @since JDK 17
 */
@AutoConfiguration(before = [BindingServiceConfiguration::class, AcpCloudLogAutoConfiguration::class])
@ConditionalOnExpression("'\${acp.cloud.log-server.client.enabled}'.equals('true')")
class AcpCloudLogServerClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(LogBridge::class)
    fun streamLogBridge(streamBridge: StreamBridge, objectMapper: ObjectMapper): LogBridge =
        StreamLogBridge(streamBridge, objectMapper, AcpCloudLogConstant.OUTPUT)
}
