package io.gitee.zhangbinhub.acp.cloud

import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudLogServerClientConfiguration
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudLogServerConfiguration
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudTransmitHeaderConfiguration
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.boot.autoconfigure.web.ServerProperties
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.cloud.context.config.annotation.RefreshScope
import org.springframework.cloud.openfeign.FeignAutoConfiguration
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties
import org.springframework.context.annotation.Bean

/**
 * @since JDK 17
 */
@AutoConfiguration(after = [FeignAutoConfiguration::class])
@EnableConfigurationProperties(
    AcpCloudLogServerConfiguration::class,
    AcpCloudLogServerClientConfiguration::class,
    AcpCloudTransmitHeaderConfiguration::class
)
class AcpCloudPropertiesAutoConfiguration {
    /**
     * 获取服务配置信息
     *
     * @return ServerProperties
     */
    @Bean
    @ConditionalOnMissingBean(ServerProperties::class)
    @RefreshScope
    fun serverProperties(): ServerProperties = ServerProperties()

    /**
     * feign客户端配置
     *
     * @return FeignHttpClientProperties
     */
    @Bean
    @ConditionalOnMissingBean(FeignHttpClientProperties::class)
    @RefreshScope
    fun feignHttpClientProperties(): FeignHttpClientProperties = FeignHttpClientProperties()
}
