package io.gitee.zhangbinhub.acp.cloud.annotation

/**
 * @since JDK 17
 */
@Target(AnnotationTarget.FUNCTION, AnnotationTarget.PROPERTY_GETTER, AnnotationTarget.PROPERTY_SETTER)
@Retention(AnnotationRetention.RUNTIME)
@MustBeDocumented
annotation class AcpCloudDuplicateSubmission(
    /**
     * key的表达式，默认"\[key\]"
     *
     * @return key
     */
    val keyExpress: String = DEFAULT_KEY_EXPRESS,
    /**
     * 超时时间，单位毫秒，默认1秒
     *
     * @return 过期时间
     */
    val expire: Long = 1000
) {
    companion object {
        const val DEFAULT_KEY_EXPRESS = "[key]"
    }
}
