package io.gitee.zhangbinhub.acp.cloud.conf;

import io.gitee.zhangbinhub.acp.cloud.constant.AcpCloudConstant;
import io.gitee.zhangbinhub.acp.cloud.constant.AcpCloudLogConstant;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = AcpCloudConstant.LOG_SERVER_CLIENT_PROPERTIES_PREFIX)
public class AcpCloudLogServerClientConfiguration {
    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    /**
     * 是否启用日志服务客户端，默认：false
     */
    private Boolean enabled = false;

    /**
     * 日志类型，默认："ALL"
     */
    private String logType = AcpCloudLogConstant.DEFAULT_TYPE;
}
