package io.gitee.zhangbinhub.acp.cloud.conf;

import io.gitee.zhangbinhub.acp.cloud.constant.AcpCloudConstant;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = AcpCloudConstant.LOG_SERVER_PROPERTIES_PREFIX)
public class AcpCloudLogServerConfiguration {
    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    /**
     * 消费日志消息的组id，多个日志服务使用相同的组id，能够保证日志消息不被重复消费，默认："acp_cloud_log_server_group_id"
     */
    private String groupId = AcpCloudConstant.LOG_SERVER_DEFAULT_GROUP_ID;

    /**
     * 当前服务是否是日志服务，默认：false
     */
    private Boolean enabled = false;

    /**
     * 日志消息的topic名称（队列名称），默认："acp_cloud_log_server_message_topic"
     */
    private String destination = AcpCloudConstant.LOG_SERVER_DEFAULT_MESSAGE_TOPIC;
}
