package io.gitee.zhangbinhub.acp.cloud.log

import io.gitee.zhangbinhub.acp.core.common.exceptions.EnumValueUndefinedException

/**
 * 日志记录级别
 *
 * @since JDK 17
 */
enum class AcpCloudLogLevel {
    Info,
    Debug,
    Warn,
    Error,
    Trace,
    Other;

    companion object {
        private var map: MutableMap<String, AcpCloudLogLevel> = mutableMapOf()

        init {
            for (level in entries) {
                map[level.name.uppercase()] = level
            }
        }

        @JvmStatic
        @Throws(EnumValueUndefinedException::class)
        fun getEnum(name: String): AcpCloudLogLevel {
            return if (map.containsKey(name.uppercase())) {
                map.getValue(name.uppercase())
            } else {
                throw EnumValueUndefinedException(AcpCloudLogLevel::class.java, name)
            }
        }
    }

}
