package io.gitee.zhangbinhub.acp.cloud.log.producer

import com.fasterxml.jackson.databind.ObjectMapper
import io.gitee.zhangbinhub.acp.cloud.log.AcpCloudLogInfo
import org.springframework.cloud.stream.function.StreamBridge
import org.springframework.messaging.support.MessageBuilder

class StreamLogBridge(
    private val streamBridge: StreamBridge,
    private val objectMapper: ObjectMapper,
    private val bindName: String
) : LogBridge {
    override fun send(acpCloudLogInfo: AcpCloudLogInfo) {
        streamBridge.send(
            bindName,
            MessageBuilder.withPayload(objectMapper.writeValueAsString(acpCloudLogInfo)).build()
        )
    }
}