/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud;

import io.gitee.zhangbinhub.acp.boot.component.BootLogAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.bus.BusPathMatcher;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.DefaultBusPathMatcher;
import org.springframework.cloud.bus.PathServiceMatcher;
import org.springframework.cloud.bus.PathServiceMatcherAutoConfiguration;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@AutoConfiguration(before={PathServiceMatcherAutoConfiguration.class}, after={RefreshAutoConfiguration.class})
@ConditionalOnBusEnabled
@EnableConfigurationProperties(value={BusProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudBusAutoConfiguration;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/boot/context/event/ApplicationStartedEvent;", "contextRefresher", "Lorg/springframework/cloud/context/refresh/ContextRefresher;", "<init>", "(Lorg/springframework/cloud/context/refresh/ContextRefresher;)V", "logAdapter", "Lio/gitee/zhangbinhub/acp/boot/component/BootLogAdapter;", "busPathMatcher", "Lorg/springframework/util/PathMatcher;", "pathServiceMatcher", "Lorg/springframework/cloud/bus/ServiceMatcher;", "pathMatcher", "properties", "Lorg/springframework/cloud/bus/BusProperties;", "environment", "Lorg/springframework/core/env/Environment;", "onApplicationEvent", "", "event", "Companion", "acp-spring-cloud-starter"})
public class AcpCloudBusAutoConfiguration
implements ApplicationListener<ApplicationStartedEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContextRefresher contextRefresher;
    @NotNull
    private final BootLogAdapter logAdapter;
    @NotNull
    public static final String BUS_PATH_MATCHER_NAME = "busPathMatcher";
    @NotNull
    public static final String CLOUD_CONFIG_NAME_PROPERTY = "spring.cloud.config.name";

    public AcpCloudBusAutoConfiguration(@NotNull ContextRefresher contextRefresher) {
        Intrinsics.checkNotNullParameter((Object)contextRefresher, (String)"contextRefresher");
        this.contextRefresher = contextRefresher;
        this.logAdapter = new BootLogAdapter();
    }

    @BusPathMatcher
    @ConditionalOnMissingBean(name={"busPathMatcher"})
    @Bean(name={"busPathMatcher"})
    @NotNull
    public PathMatcher busPathMatcher() {
        return (PathMatcher)new DefaultBusPathMatcher((PathMatcher)new AntPathMatcher(":"));
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(value={ServiceMatcher.class})
    @NotNull
    public ServiceMatcher pathServiceMatcher(@BusPathMatcher @NotNull PathMatcher pathMatcher, @NotNull BusProperties properties, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)pathMatcher, (String)"pathMatcher");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String[] configNames = (String[])environment.getProperty(CLOUD_CONFIG_NAME_PROPERTY, String[].class, (Object)new String[0]);
        return (ServiceMatcher)new PathServiceMatcher(pathMatcher, properties.getId(), configNames);
    }

    public void onApplicationEvent(@NotNull ApplicationStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.logAdapter.info("Application has started with " + event.getTimeTaken().toMillis() + " millisecond, then will reload the properties and refresh the bus id.");
        this.contextRefresher.refresh();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudBusAutoConfiguration$Companion;", "", "<init>", "()V", "BUS_PATH_MATCHER_NAME", "", "CLOUD_CONFIG_NAME_PROPERTY", "acp-spring-cloud-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

