/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud;

import io.gitee.zhangbinhub.acp.boot.AcpBootLogAutoConfiguration;
import io.gitee.zhangbinhub.acp.boot.log.LogAdapter;
import io.gitee.zhangbinhub.acp.cloud.component.CloudLogAdapter;
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudLogServerClientConfiguration;
import io.gitee.zhangbinhub.acp.cloud.log.AcpCloudLogInfo;
import io.gitee.zhangbinhub.acp.cloud.log.producer.LogBridge;
import io.gitee.zhangbinhub.acp.cloud.tools.CloudTools;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

@AutoConfiguration(before={AcpBootLogAutoConfiguration.class})
@ConditionalOnExpression(value="'${acp.cloud.log-server.client.enabled}'.equals('true')")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0017\u00a8\u0006\u000e"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudLogAutoConfiguration;", "", "<init>", "()V", "logAdapter", "Lio/gitee/zhangbinhub/acp/boot/log/LogAdapter;", "cloudTools", "Lio/gitee/zhangbinhub/acp/cloud/tools/CloudTools;", "acpCloudLogServerClientConfiguration", "Lio/gitee/zhangbinhub/acp/cloud/conf/AcpCloudLogServerClientConfiguration;", "logBridge", "Lio/gitee/zhangbinhub/acp/cloud/log/producer/LogBridge;", "cloudLogInfo", "Lio/gitee/zhangbinhub/acp/cloud/log/AcpCloudLogInfo;", "acp-spring-cloud-starter"})
public class AcpCloudLogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LogAdapter.class})
    @NotNull
    public LogAdapter logAdapter(@NotNull CloudTools cloudTools, @NotNull AcpCloudLogServerClientConfiguration acpCloudLogServerClientConfiguration, @NotNull LogBridge logBridge) {
        Intrinsics.checkNotNullParameter((Object)cloudTools, (String)"cloudTools");
        Intrinsics.checkNotNullParameter((Object)acpCloudLogServerClientConfiguration, (String)"acpCloudLogServerClientConfiguration");
        Intrinsics.checkNotNullParameter((Object)logBridge, (String)"logBridge");
        return new CloudLogAdapter(cloudTools, acpCloudLogServerClientConfiguration, logBridge);
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public AcpCloudLogInfo cloudLogInfo() {
        return new AcpCloudLogInfo();
    }
}

