/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gitee.zhangbinhub.acp.cloud.AcpCloudComponentAutoConfiguration;
import io.gitee.zhangbinhub.acp.cloud.log.AcpCloudLogInfo;
import io.gitee.zhangbinhub.acp.cloud.log.consumer.DefaultLogProcess;
import io.gitee.zhangbinhub.acp.cloud.log.consumer.LogProcess;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import io.gitee.zhangbinhub.acp.core.common.log.LogFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={BindingServiceConfiguration.class, AcpCloudComponentAutoConfiguration.class})
@ConditionalOnExpression(value="'${acp.cloud.log-server.enabled}'.equals('true')")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0017J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/AcpCloudLogServerAutoConfiguration;", "", "<init>", "()V", "logFactory", "Lio/gitee/zhangbinhub/acp/core/common/log/LogFactory;", "logProcess", "Lio/gitee/zhangbinhub/acp/cloud/log/consumer/LogProcess;", "logConsumer", "Lkotlin/Function1;", "", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "acp-spring-cloud-starter"})
public class AcpCloudLogServerAutoConfiguration {
    @NotNull
    private final LogFactory logFactory = LogFactory.Companion.getInstance$default((LogFactory.Companion)LogFactory.Companion, this.getClass(), (int)0, (int)2, null);

    @Bean
    @ConditionalOnMissingBean(value={LogProcess.class})
    @NotNull
    public LogProcess logProcess() {
        return new DefaultLogProcess();
    }

    @Bean(value={"acpLogConsumer"})
    @ConditionalOnMissingBean(name={"acpLogConsumer"})
    @NotNull
    public Function1<String, Unit> logConsumer(@NotNull ObjectMapper objectMapper, @NotNull LogProcess logProcess) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)logProcess, (String)"logProcess");
        return arg_0 -> AcpCloudLogServerAutoConfiguration.logConsumer$lambda$0(objectMapper, logProcess, this, arg_0);
    }

    private static final Unit logConsumer$lambda$0(ObjectMapper $objectMapper, LogProcess $logProcess, AcpCloudLogServerAutoConfiguration this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            Object object = $objectMapper.readValue(it, AcpCloudLogInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            AcpCloudLogInfo acpCloudLogInfo = (AcpCloudLogInfo)object;
            String logType = "ALL";
            if (!CommonTools.isNullStr((String)acpCloudLogInfo.getLogType())) {
                logType = acpCloudLogInfo.getLogType();
            }
            acpCloudLogInfo.setLogType(logType);
            $logProcess.process(acpCloudLogInfo);
        }
        catch (Exception e) {
            this$0.logFactory.error(e.getMessage(), (Throwable)e);
        }
        return Unit.INSTANCE;
    }
}

