/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangbinhub.acp.cloud.tools;

import feign.RequestTemplate;
import io.gitee.zhangbinhub.acp.boot.component.BootLogAdapter;
import io.gitee.zhangbinhub.acp.boot.tools.ReactiveRequestContextHolder;
import io.gitee.zhangbinhub.acp.boot.tools.ServerTools;
import io.gitee.zhangbinhub.acp.cloud.conf.AcpCloudTransmitHeaderConfiguration;
import io.gitee.zhangbinhub.acp.core.common.CommonTools;
import jakarta.servlet.http.HttpServletRequest;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J&\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0007J\"\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0007J\u0012\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/tools/CloudTools;", "", "acpCloudTransmitHeaderConfiguration", "Lio/gitee/zhangbinhub/acp/cloud/conf/AcpCloudTransmitHeaderConfiguration;", "serverTools", "Lio/gitee/zhangbinhub/acp/boot/tools/ServerTools;", "inetUtils", "Lorg/springframework/cloud/commons/util/InetUtils;", "<init>", "(Lio/gitee/zhangbinhub/acp/cloud/conf/AcpCloudTransmitHeaderConfiguration;Lio/gitee/zhangbinhub/acp/boot/tools/ServerTools;Lorg/springframework/cloud/commons/util/InetUtils;)V", "ip", "", "logAdapter", "Lio/gitee/zhangbinhub/acp/boot/component/BootLogAdapter;", "getServerPort", "", "getServerIp", "includeHeader", "", "headerName", "includeAuthorization", "transmitHeadersFeign", "", "requestTemplate", "Lfeign/RequestTemplate;", "servletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "transmitHeadersServlet", "headers", "Lorg/springframework/http/HttpHeaders;", "transmitHeadersReactive", "serverHttpRequest", "Lorg/springframework/http/server/reactive/ServerHttpRequest;", "headerFilterFunction", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "Companion", "acp-spring-cloud-starter"})
@SourceDebugExtension(value={"SMAP\nCloudTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudTools.kt\nio/gitee/zhangbinhub/acp/cloud/tools/CloudTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1863#2,2:162\n1863#2,2:164\n1#3:166\n*S KotlinDebug\n*F\n+ 1 CloudTools.kt\nio/gitee/zhangbinhub/acp/cloud/tools/CloudTools\n*L\n57#1:162,2\n82#1:164,2\n*E\n"})
public final class CloudTools {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AcpCloudTransmitHeaderConfiguration acpCloudTransmitHeaderConfiguration;
    @NotNull
    private final ServerTools serverTools;
    @NotNull
    private final InetUtils inetUtils;
    @Value(value="${server.address:}")
    @Nullable
    private String ip;
    @NotNull
    private final BootLogAdapter logAdapter;

    public CloudTools(@NotNull AcpCloudTransmitHeaderConfiguration acpCloudTransmitHeaderConfiguration, @NotNull ServerTools serverTools, @NotNull InetUtils inetUtils) {
        Intrinsics.checkNotNullParameter((Object)acpCloudTransmitHeaderConfiguration, (String)"acpCloudTransmitHeaderConfiguration");
        Intrinsics.checkNotNullParameter((Object)serverTools, (String)"serverTools");
        Intrinsics.checkNotNullParameter((Object)inetUtils, (String)"inetUtils");
        this.acpCloudTransmitHeaderConfiguration = acpCloudTransmitHeaderConfiguration;
        this.serverTools = serverTools;
        this.inetUtils = inetUtils;
        this.logAdapter = new BootLogAdapter();
    }

    public final int getServerPort() {
        return this.serverTools.getServerPort();
    }

    @NotNull
    public final String getServerIp() {
        String string;
        if (CommonTools.isNullStr((String)this.ip)) {
            String string2;
            try {
                String string3 = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                if (string3 == null) {
                    string3 = this.serverTools.getServerIp();
                }
                string2 = string3;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                string2 = "";
            }
            string = string2;
        } else {
            String string4 = this.ip;
            string = string4;
            Intrinsics.checkNotNull((Object)string4);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean includeHeader(String headerName, boolean includeAuthorization) {
        if (includeAuthorization) {
            if (StringsKt.equals((String)headerName, (String)"Authorization", (boolean)true)) return true;
        }
        String string = this.acpCloudTransmitHeaderConfiguration.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        if (!StringsKt.startsWith((String)headerName, (String)string, (boolean)true)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void transmitHeadersFeign(@NotNull RequestTemplate requestTemplate, @Nullable HttpServletRequest servletRequest) {
        block2: {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)requestTemplate, (String)"requestTemplate");
            HttpServletRequest httpServletRequest = servletRequest;
            if (httpServletRequest == null) {
                httpServletRequest = Companion.getServletRequest();
            }
            if (httpServletRequest == null) break block2;
            HttpServletRequest request = httpServletRequest;
            boolean bl = false;
            Enumeration enumeration = request.getHeaderNames();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable iterable = arrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                String headerName = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)headerName);
                if (!this.includeHeader(headerName, true)) continue;
                Enumeration enumeration2 = request.getHeaders(headerName);
                Intrinsics.checkNotNullExpressionValue((Object)enumeration2, (String)"getHeaders(...)");
                ArrayList arrayList2 = Collections.list(enumeration2);
                Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
                List $this$transmitHeadersFeign_u24lambda_u242_u24lambda_u241_u24lambda_u240 = list = (List)arrayList2;
                boolean bl3 = false;
                if (!(!((Collection)$this$transmitHeadersFeign_u24lambda_u242_u24lambda_u241_u24lambda_u240).isEmpty())) continue;
                this.logAdapter.debug("feign[" + requestTemplate.url() + "] transmit header [" + headerName + "]: " + $this$transmitHeadersFeign_u24lambda_u242_u24lambda_u241_u24lambda_u240);
                requestTemplate.header(headerName, (Iterable)$this$transmitHeadersFeign_u24lambda_u242_u24lambda_u241_u24lambda_u240);
            }
        }
    }

    public static /* synthetic */ void transmitHeadersFeign$default(CloudTools cloudTools, RequestTemplate requestTemplate, HttpServletRequest httpServletRequest, int n, Object object) {
        if ((n & 2) != 0) {
            httpServletRequest = null;
        }
        cloudTools.transmitHeadersFeign(requestTemplate, httpServletRequest);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void transmitHeadersServlet(@NotNull HttpHeaders headers, @Nullable HttpServletRequest servletRequest, boolean includeAuthorization) {
        block2: {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            HttpServletRequest httpServletRequest = servletRequest;
            if (httpServletRequest == null) {
                httpServletRequest = Companion.getServletRequest();
            }
            if (httpServletRequest == null) break block2;
            HttpServletRequest request = httpServletRequest;
            boolean bl = false;
            Enumeration enumeration = request.getHeaderNames();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable iterable = arrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                String headerName = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)headerName);
                if (!this.includeHeader(headerName, includeAuthorization)) continue;
                Enumeration enumeration2 = request.getHeaders(headerName);
                Intrinsics.checkNotNullExpressionValue((Object)enumeration2, (String)"getHeaders(...)");
                ArrayList arrayList2 = Collections.list(enumeration2);
                Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
                List $this$transmitHeadersServlet_u24lambda_u245_u24lambda_u244_u24lambda_u243 = list = (List)arrayList2;
                boolean bl3 = false;
                if (!(!((Collection)$this$transmitHeadersServlet_u24lambda_u245_u24lambda_u244_u24lambda_u243).isEmpty())) continue;
                this.logAdapter.debug("restClient transmit header [" + headerName + "]: " + $this$transmitHeadersServlet_u24lambda_u245_u24lambda_u244_u24lambda_u243);
                headers.addAll(headerName, $this$transmitHeadersServlet_u24lambda_u245_u24lambda_u244_u24lambda_u243);
            }
        }
    }

    public static /* synthetic */ void transmitHeadersServlet$default(CloudTools cloudTools, HttpHeaders httpHeaders, HttpServletRequest httpServletRequest, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            httpServletRequest = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        cloudTools.transmitHeadersServlet(httpHeaders, httpServletRequest, bl);
    }

    @JvmOverloads
    public final void transmitHeadersReactive(@NotNull HttpHeaders headers, @NotNull ServerHttpRequest serverHttpRequest, boolean includeAuthorization) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)serverHttpRequest, (String)"serverHttpRequest");
        serverHttpRequest.getHeaders().forEach((arg_0, arg_1) -> CloudTools.transmitHeadersReactive$lambda$7((arg_0, arg_1) -> CloudTools.transmitHeadersReactive$lambda$6(this, includeAuthorization, headers, arg_0, arg_1), arg_0, arg_1));
    }

    public static /* synthetic */ void transmitHeadersReactive$default(CloudTools cloudTools, HttpHeaders httpHeaders, ServerHttpRequest serverHttpRequest, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        cloudTools.transmitHeadersReactive(httpHeaders, serverHttpRequest, bl);
    }

    @JvmOverloads
    @NotNull
    public final ExchangeFilterFunction headerFilterFunction(boolean includeAuthorization) {
        return (arg_0, arg_1) -> CloudTools.headerFilterFunction$lambda$14(this, includeAuthorization, arg_0, arg_1);
    }

    public static /* synthetic */ ExchangeFilterFunction headerFilterFunction$default(CloudTools cloudTools, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return cloudTools.headerFilterFunction(bl);
    }

    @JvmOverloads
    public final void transmitHeadersFeign(@NotNull RequestTemplate requestTemplate) {
        Intrinsics.checkNotNullParameter((Object)requestTemplate, (String)"requestTemplate");
        CloudTools.transmitHeadersFeign$default(this, requestTemplate, null, 2, null);
    }

    @JvmOverloads
    public final void transmitHeadersServlet(@NotNull HttpHeaders headers, @Nullable HttpServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        CloudTools.transmitHeadersServlet$default(this, headers, servletRequest, false, 4, null);
    }

    @JvmOverloads
    public final void transmitHeadersServlet(@NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        CloudTools.transmitHeadersServlet$default(this, headers, null, false, 6, null);
    }

    @JvmOverloads
    public final void transmitHeadersReactive(@NotNull HttpHeaders headers, @NotNull ServerHttpRequest serverHttpRequest) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)serverHttpRequest, (String)"serverHttpRequest");
        CloudTools.transmitHeadersReactive$default(this, headers, serverHttpRequest, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final ExchangeFilterFunction headerFilterFunction() {
        return CloudTools.headerFilterFunction$default(this, false, 1, null);
    }

    private static final Unit transmitHeadersReactive$lambda$6(CloudTools this$0, boolean $includeAuthorization, HttpHeaders $headers, String headerName, List headerValues) {
        Intrinsics.checkNotNull((Object)headerName);
        if (this$0.includeHeader(headerName, $includeAuthorization)) {
            Intrinsics.checkNotNull((Object)headerValues);
            if (!((Collection)headerValues).isEmpty()) {
                this$0.logAdapter.debug("webClient transmit header [" + headerName + "]: " + headerValues);
                $headers.addAll(headerName, headerValues);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void transmitHeadersReactive$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void headerFilterFunction$lambda$14$lambda$10$lambda$8(CloudTools this$0, ServerHttpRequest $serverHttpRequest, boolean $includeAuthorization, HttpHeaders headers) {
        Intrinsics.checkNotNull((Object)headers);
        Intrinsics.checkNotNull((Object)$serverHttpRequest);
        this$0.transmitHeadersReactive(headers, $serverHttpRequest, $includeAuthorization);
    }

    private static final Mono headerFilterFunction$lambda$14$lambda$10(ClientRequest $request, CloudTools this$0, boolean $includeAuthorization, ExchangeFunction $next, ServerHttpRequest serverHttpRequest) {
        ClientRequest it = ClientRequest.from((ClientRequest)$request).headers(arg_0 -> CloudTools.headerFilterFunction$lambda$14$lambda$10$lambda$8(this$0, serverHttpRequest, $includeAuthorization, arg_0)).build();
        boolean bl = false;
        return $next.exchange(it);
    }

    private static final Mono headerFilterFunction$lambda$14$lambda$11(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono headerFilterFunction$lambda$14$lambda$12(CloudTools this$0, ExchangeFunction $next, ClientRequest $request, Throwable throwable) {
        this$0.logAdapter.error("webClient headerFilterFunction error: " + throwable.getMessage(), throwable);
        return $next.exchange($request);
    }

    private static final Mono headerFilterFunction$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono headerFilterFunction$lambda$14(CloudTools this$0, boolean $includeAuthorization, ClientRequest request, ExchangeFunction next) {
        return Companion.getReactiveRequest().flatMap(arg_0 -> CloudTools.headerFilterFunction$lambda$14$lambda$11(arg_0 -> CloudTools.headerFilterFunction$lambda$14$lambda$10(request, this$0, $includeAuthorization, next, arg_0), arg_0)).onErrorResume(arg_0 -> CloudTools.headerFilterFunction$lambda$14$lambda$13(arg_0 -> CloudTools.headerFilterFunction$lambda$14$lambda$12(this$0, next, request, arg_0), arg_0));
    }

    @JvmStatic
    @Nullable
    public static final HttpServletRequest getServletRequest() {
        return Companion.getServletRequest();
    }

    @JvmStatic
    @NotNull
    public static final Mono<ServerHttpRequest> getReactiveRequest() {
        return Companion.getReactiveRequest();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lio/gitee/zhangbinhub/acp/cloud/tools/CloudTools$Companion;", "", "<init>", "()V", "getServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "getReactiveRequest", "Lreactor/core/publisher/Mono;", "Lorg/springframework/http/server/reactive/ServerHttpRequest;", "acp-spring-cloud-starter"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final HttpServletRequest getServletRequest() {
            RequestAttributes it = RequestContextHolder.getRequestAttributes();
            boolean bl = false;
            return it instanceof ServletRequestAttributes ? ((ServletRequestAttributes)it).getRequest() : null;
        }

        @JvmStatic
        @NotNull
        public final Mono<ServerHttpRequest> getReactiveRequest() {
            return ReactiveRequestContextHolder.getRequest();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

