/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Gui;

import io.gitee.zhangsisiyao.ForgeAPI.Gui.IBaseGUI;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTextureLoader;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTexturePos2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class BaseGui
extends Gui
implements IBaseGUI {
    protected Minecraft mc = Minecraft.getMinecraft();
    protected FontRenderer fontRenderer;
    protected boolean visible;
    protected boolean hovered;
    protected String id;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected GuiTextureLoader guiTextureLoader;
    protected boolean enableTexture;
    protected Gui frame;
    protected int maxWidth;
    protected int maxHeight;

    public BaseGui() {
        this.fontRenderer = Minecraft.getMinecraft().fontRenderer;
        this.visible = true;
        this.enableTexture = true;
    }

    public static void drawCustomSizedTexture(int x, int y, int width, int height, GuiTexturePos2D texturePos) {
        float f = 1.0f / texturePos.getMaxWidth();
        float f1 = 1.0f / texturePos.getMaxHeight();
        float u = texturePos.getU();
        float v = texturePos.getV();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(7, DefaultVertexFormats.POSITION_TEX);
        bufferbuilder.pos((double)x, (double)(y + height), 0.0).tex((double)(u * f), (double)((v + (float)texturePos.getHeight()) * f1)).endVertex();
        bufferbuilder.pos((double)(x + width), (double)(y + height), 0.0).tex((double)((u + (float)texturePos.getWidth()) * f), (double)((v + (float)texturePos.getHeight()) * f1)).endVertex();
        bufferbuilder.pos((double)(x + width), (double)y, 0.0).tex((double)((u + (float)texturePos.getWidth()) * f), (double)(v * f1)).endVertex();
        bufferbuilder.pos((double)x, (double)y, 0.0).tex((double)(u * f), (double)(v * f1)).endVertex();
        tessellator.draw();
    }

    public void setTexture(GuiTextureLoader loader) {
        this.guiTextureLoader.deleteTexture();
        this.guiTextureLoader = loader;
    }

    @Override
    public void drawGUI(int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void mouseDragged(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void playPressSound(SoundHandler soundHandlerIn) {
    }

    @Override
    public void updateGUI() {
    }

    @Override
    public void KeyInput(char typedChar, int keyCode) {
    }

    @Override
    public void setResolution(int width, int height) {
        this.maxHeight = height;
        this.maxWidth = width;
    }

    @Override
    public void onGuiClosed() {
        if (this.guiTextureLoader != null) {
            this.guiTextureLoader.deleteTexture();
            this.guiTextureLoader.stopGifTread();
        }
    }

    @Override
    public String getGuiID() {
        return this.id;
    }

    @Override
    public Gui getFrame() {
        return this.frame;
    }

    @Override
    public void setFrame(Gui frame) {
        this.frame = frame;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setEnableTexture(boolean enableTexture) {
        this.enableTexture = enableTexture;
    }
}

