/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Gui.Impl;

import io.gitee.zhangsisiyao.ForgeAPI.Gui.BaseGui;
import io.gitee.zhangsisiyao.ForgeAPI.Gui.ex.GuiBaseException;
import io.gitee.zhangsisiyao.ForgeAPI.Gui.ex.ParamErrorException;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTextureLoader;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTexturePos2D;
import io.gitee.zhangsisiyao.ForgeAPI.Utils.ResourcesUtil;
import java.io.File;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Bar
extends BaseGui {
    protected final float min = 0.0f;
    protected final float max = 100.0f;
    protected float curr;
    protected int BackColor = 0xFFFAFA;
    protected int OverlapColor = 0x668B8B;
    protected GuiTexturePos2D backTexture;
    protected GuiTexturePos2D overlapTexture;

    public Bar(String id, float curr, int x, int y, int width, int height) {
        if (curr > 100.0f || curr < 0.0f) {
            throw new ParamErrorException("\u8fdb\u5ea6\u6761\u8fdb\u5ea6\u503c\u5927\u4e8e100\u6216\u5c0f\u4e8e0");
        }
        if (x < 0 || y < 0) {
            throw new GuiBaseException("x\u5750\u6807\u6216y\u5750\u6807\u503c\u5c0f\u4e8e0");
        }
        if (width < 0 || height < 0) {
            throw new GuiBaseException("\u5bbd\u5ea6width\u6216\u9ad8\u5ea6height\u5c0f\u4e8e0");
        }
        this.id = id;
        this.y = y;
        this.x = x;
        this.curr = curr;
        this.width = width;
        this.height = height;
        this.guiTextureLoader = new GuiTextureLoader(new File(ResourcesUtil.getResourcesPath("assets/texture/Weight/Bar/bars.png")));
        this.backTexture = new GuiTexturePos2D(0.0f, 0.0f, 182, 5, 256.0f, 256.0f);
        this.overlapTexture = new GuiTexturePos2D(0.0f, 5.0f, 182, 5, 256.0f, 256.0f);
    }

    @Override
    public void drawGUI(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.enableTexture && this.guiTextureLoader != null) {
                this.guiTextureLoader.bindTexture();
                if (this.guiTextureLoader.getGlTextureId() != -1) {
                    this.drawTexture();
                }
            } else {
                this.drawColor();
            }
        }
    }

    private void drawColor() {
        Bar.drawRect((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(-16777216 + this.BackColor));
        Bar.drawRect((int)this.x, (int)this.y, (int)(this.x + (int)((float)this.width * (this.curr / 100.0f))), (int)(this.y + this.height), (int)(-16777216 + this.OverlapColor));
    }

    private void drawTexture() {
        Bar.drawCustomSizedTexture(this.x, this.y, this.width, this.height, this.backTexture);
        if (this.curr != 0.0f) {
            GuiTexturePos2D currOverlapTexture = new GuiTexturePos2D(this.overlapTexture.getU(), this.overlapTexture.getV(), (int)((float)this.overlapTexture.getWidth() * (this.curr / 100.0f)), this.overlapTexture.getHeight(), this.overlapTexture.getMaxWidth(), this.overlapTexture.getMaxWidth());
            Bar.drawCustomSizedTexture(this.x, this.y, (int)((float)this.width * (this.curr / 100.0f)), this.height, currOverlapTexture);
        }
    }

    public float getCurr() {
        return this.curr;
    }

    public void setCurr(float curr) {
        this.curr = curr;
    }

    public void setTexture(GuiTexturePos2D backTexture, GuiTexturePos2D overlapTexture) {
        this.backTexture = backTexture;
        this.overlapTexture = overlapTexture;
    }

    @Override
    public void updateGUI() {
        super.updateGUI();
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
    }

    public void setBackColor(int backColor) {
        this.BackColor = backColor;
    }

    public void setOverlapColor(int overlapColor) {
        this.OverlapColor = overlapColor;
    }
}

