/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Gui.Impl;

import io.gitee.zhangsisiyao.ForgeAPI.Gui.BaseGui;
import io.gitee.zhangsisiyao.ForgeAPI.Gui.ex.GuiBaseException;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTextureLoader;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTexturePos2D;
import io.gitee.zhangsisiyao.ForgeAPI.Utils.ResourcesUtil;
import java.io.File;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Button
extends BaseGui {
    public String displayString;
    public boolean enabled;
    public int packedFGColour;
    protected int buttonColor = 0xBBFFFF;
    protected int buttonHorveredColor = 9883085;
    protected GuiTexturePos2D texturePos;
    protected GuiTexturePos2D hoveredTexturePos;
    protected int border = 0;
    protected int brColor = 34443;

    public Button(String buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
        if (x < 0 || y < 0) {
            throw new GuiBaseException("x\u5750\u6807\u6216y\u5750\u6807\u503c\u5c0f\u4e8e0");
        }
        if (widthIn < 0 || heightIn < 0) {
            throw new GuiBaseException("\u5bbd\u5ea6width\u6216\u9ad8\u5ea6height\u5c0f\u4e8e0");
        }
        this.width = 200;
        this.height = 20;
        this.enabled = true;
        this.visible = true;
        this.id = buttonId;
        this.x = x;
        this.y = y;
        this.width = widthIn;
        this.height = heightIn;
        this.displayString = buttonText;
        this.guiTextureLoader = new GuiTextureLoader(new File(ResourcesUtil.getResourcesPath("assets/texture/Weight/Button/widgets.png")));
        this.texturePos = new GuiTexturePos2D(0.0f, 66.0f, 200, 20, 256.0f, 256.0f);
        this.hoveredTexturePos = new GuiTexturePos2D(0.0f, 86.0f, 200, 20, 256.0f, 256.0f);
    }

    @Override
    public void drawGUI(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            FontRenderer fontrenderer = this.mc.fontRenderer;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (this.guiTextureLoader.getGlTextureId() != -1 && this.enableTexture) {
                this.drawButtonTexture();
            } else {
                this.drawButtonColor();
            }
            this.mouseDragged(mouseX, mouseY, 0);
            this.drawText();
        }
    }

    private void drawButtonTexture() {
        this.guiTextureLoader.bindTexture();
        GuiTexturePos2D guiTexturePos2D = this.getHoverState() == 1 ? this.texturePos : this.hoveredTexturePos;
        Button.drawCustomSizedTexture(this.x, this.y, this.width, this.height, guiTexturePos2D);
    }

    private void drawButtonColor() {
        int backWidth = this.width - this.border;
        int backHeight = this.height - this.border;
        int backX = this.x + this.border;
        int backY = this.y + this.border;
        int color = this.getHoverState() == 1 ? this.buttonColor : this.buttonHorveredColor;
        Button.drawRect((int)backX, (int)backY, (int)(this.x + backWidth), (int)(this.y + backHeight), (int)(-16777216 + color));
        Button.drawRect((int)this.x, (int)this.y, (int)(this.x + this.width), (int)backY, (int)(-16777216 + this.brColor));
        Button.drawRect((int)this.x, (int)(this.y + backHeight), (int)(this.x + this.width), (int)(this.y + this.height), (int)(-16777216 + this.brColor));
        Button.drawRect((int)this.x, (int)this.y, (int)backX, (int)(this.y + this.height), (int)(-16777216 + this.brColor));
        Button.drawRect((int)(this.x + backWidth), (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(-16777216 + this.brColor));
    }

    private void drawText() {
        int j = 0xE0E0E0;
        if (this.packedFGColour != 0) {
            j = this.packedFGColour;
        } else if (!this.enabled) {
            j = 0xA0A0A0;
        } else if (this.hovered) {
            j = 0xFFFFA0;
        }
        this.drawCenteredString(this.fontRenderer, I18n.format((String)this.displayString, (Object[])new Object[0]), this.x + this.width / 2, this.y + (this.height - 8) / 2, j);
    }

    protected int getHoverState() {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (this.hovered) {
            i = 2;
        }
        return i;
    }

    public boolean isMouseOvered() {
        return this.hovered;
    }

    public void setTexturePos(GuiTexturePos2D texturePos, GuiTexturePos2D hoveredTexturePos) {
        this.texturePos = texturePos;
        this.hoveredTexturePos = hoveredTexturePos;
    }

    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    public void setButtonColor(int buttonColor, int buttonHorveredColor) {
        this.buttonColor = buttonColor;
        this.buttonHorveredColor = buttonHorveredColor;
    }

    public void setBorder(int width) {
        this.border = this.border;
    }

    public void setBrColor(int brColor) {
        this.brColor = brColor;
    }
}

