/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Gui.Impl;

import io.gitee.zhangsisiyao.ForgeAPI.Gui.BaseGui;
import io.gitee.zhangsisiyao.ForgeAPI.Gui.ex.GuiBaseException;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTextureLoader;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTexturePos2D;

public class Image
extends BaseGui {
    protected GuiTextureLoader imageGuiTextureLoader;
    protected GuiTexturePos2D imageTexture;

    public Image(String id, int x, int y, int width, int height, GuiTextureLoader guiTextureLoader) {
        if (x < 0 || y < 0) {
            throw new GuiBaseException("x\u5750\u6807\u6216y\u5750\u6807\u503c\u5c0f\u4e8e0");
        }
        if (width < 0 || height < 0) {
            throw new GuiBaseException("\u5bbd\u5ea6width\u6216\u9ad8\u5ea6height\u5c0f\u4e8e0");
        }
        if (guiTextureLoader == null) {
            throw new NullPointerException("ImageLoader\u7684\u503c\u4e3anull");
        }
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.imageGuiTextureLoader = guiTextureLoader;
        this.imageTexture = new GuiTexturePos2D(0.0f, 0.0f, guiTextureLoader.getImageBuffer().getWidth(), guiTextureLoader.getImageBuffer().getHeight(), guiTextureLoader.getImageBuffer().getWidth(), guiTextureLoader.getImageBuffer().getHeight());
    }

    @Override
    public void drawGUI(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.imageGuiTextureLoader.bindTexture();
            Image.drawCustomSizedTexture(this.x, this.y, this.width, this.height, this.imageTexture);
        }
    }

    public void setImageTexture(GuiTextureLoader guiTextureLoader, GuiTexturePos2D imageTexture) {
        this.imageGuiTextureLoader = guiTextureLoader;
        this.imageTexture = imageTexture;
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        this.imageGuiTextureLoader.deleteTexture();
        this.imageGuiTextureLoader.stopGifTread();
    }
}

