/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Gui.Impl;

import com.google.common.collect.Lists;
import io.gitee.zhangsisiyao.ForgeAPI.Gui.BaseGui;
import io.gitee.zhangsisiyao.ForgeAPI.Gui.ex.GuiBaseException;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTexturePos2D;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class Label
extends BaseGui {
    protected List<String> labels = Lists.newArrayList();
    protected boolean centered = false;
    protected boolean labelBgEnabled = true;
    protected GuiTexturePos2D backTexturePos;
    protected int textColor = 0;
    protected int backColor = 0xFFFFFF;
    protected int brColor = 34443;
    protected int border = 1;
    protected boolean enableLines = true;
    protected int fontSize = 9;

    public Label(String id, int x, int y, int width, int height, int fontSize) {
        if (x < 0 || y < 0) {
            throw new GuiBaseException("x\u5750\u6807\u6216y\u5750\u6807\u503c\u5c0f\u4e8e0");
        }
        if (width < 0 || height < 0) {
            throw new GuiBaseException("\u5bbd\u5ea6width\u6216\u9ad8\u5ea6height\u5c0f\u4e8e0");
        }
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.id = id;
        this.fontSize = fontSize;
    }

    @Override
    public void drawGUI(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.drawLabelBackground();
            this.drawLabelText();
        }
    }

    protected void drawLabelText() {
        int BackWidth = this.width - this.border;
        int BackHeight = this.height - this.border;
        int BackX = this.x + this.border;
        int BackY = this.y + this.border;
        float OldfontSize = 10.0f;
        GlStateManager.scale((float)((float)this.fontSize / OldfontSize), (float)((float)this.fontSize / OldfontSize), (float)0.0f);
        if (this.enableLines) {
            int MaxLine = (this.height - 2 * this.border) / this.fontSize;
            int LineCount = this.labels.size() <= MaxLine ? this.labels.size() : MaxLine;
            for (int k = 0; k < LineCount; ++k) {
                int X = this.centered ? BackX + (this.width - 2 * this.border) / 2 : BackX;
                this.drawString(this.fontRenderer, I18n.format((String)this.labels.get(k), (Object[])new Object[0]), X, BackY + this.fontSize * k, this.textColor);
            }
        } else {
            int X = this.centered ? BackX + (this.width - 2 * this.border) / 2 : BackX;
            String str = this.labels.size() > 0 ? this.labels.get(0) : "";
            this.drawString(this.fontRenderer, I18n.format((String)str, (Object[])new Object[0]), X, BackY, this.textColor);
        }
    }

    protected void drawLabelBackground() {
        if (this.labelBgEnabled) {
            if (this.enableTexture) {
                if (this.guiTextureLoader != null && this.guiTextureLoader.getGlTextureId() != -1) {
                    this.guiTextureLoader.bindTexture();
                    Label.drawCustomSizedTexture(this.x, this.y, this.width, this.height, this.backTexturePos);
                }
            } else {
                int BackWidth = this.width - this.border;
                int BackHeight = this.height - this.border;
                int BackX = this.x + this.border;
                int BackY = this.y + this.border;
                Label.drawRect((int)BackX, (int)BackY, (int)(this.x + BackWidth), (int)(this.y + BackHeight), (int)(-16777216 + this.backColor));
                Label.drawRect((int)this.x, (int)this.y, (int)(this.x + this.width), (int)BackY, (int)(-16777216 + this.brColor));
                Label.drawRect((int)this.x, (int)(this.y + BackHeight), (int)(this.x + this.width), (int)(this.y + this.height), (int)(-16777216 + this.brColor));
                Label.drawRect((int)this.x, (int)this.y, (int)BackX, (int)(this.y + this.height), (int)(-16777216 + this.brColor));
                Label.drawRect((int)(this.x + BackWidth), (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(-16777216 + this.brColor));
            }
        }
    }

    public void setBroderSize(int value) {
        this.border = value;
    }

    public void setBackEnabled(boolean value) {
        this.labelBgEnabled = value;
    }

    public void setBorderColor(int brColor) {
        this.brColor = brColor;
    }

    public void setBackColor(int value) {
        this.backColor = value;
    }

    public void addLine(String value) {
        this.labels.add(I18n.format((String)value, (Object[])new Object[0]));
    }

    public void setCentered(boolean value) {
        this.centered = value;
    }

    public void setEnableLines(boolean enableLines) {
        this.enableLines = enableLines;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setFontSize(int value) {
        this.fontSize = value;
    }
}

