/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Gui.Impl;

import io.gitee.zhangsisiyao.ForgeAPI.Gui.Impl.Button;
import io.gitee.zhangsisiyao.ForgeAPI.Texture.GuiTexturePos2D;
import net.minecraft.client.renderer.GlStateManager;

public class Slider
extends Button {
    private float sliderPosition = 1.0f;
    public boolean isMouseDown;
    private final float min;
    private final float max;
    protected String displayString;

    public Slider(String idIn, int x, int y, int width, int height, String displayString, float minIn, float maxIn, float defaultValue) {
        super(idIn, x, y, width, height, "");
        this.displayString = displayString;
        this.min = minIn;
        this.max = maxIn;
        this.sliderPosition = (defaultValue - minIn) / (maxIn - minIn);
        this.texturePos = new GuiTexturePos2D(0.0f, 46.0f, 200, 20, 256.0f, 256.0f);
        this.hoveredTexturePos = new GuiTexturePos2D(0.0f, 46.0f, 200, 20, 256.0f, 256.0f);
    }

    @Override
    public void drawGUI(int mouseX, int mouseY, float partialTicks) {
        super.drawGUI(mouseX, mouseY, partialTicks);
    }

    public float getSliderValue() {
        return this.min + (this.max - this.min) * this.sliderPosition;
    }

    public void setSliderValue(float value) {
        this.sliderPosition = (value - this.min) / (this.max - this.min);
    }

    public float getSliderPosition() {
        return this.sliderPosition;
    }

    private String getDisplayString() {
        return this.displayString;
    }

    @Override
    public void mouseDragged(int mouseX, int mouseY, int mouseButton) {
        if (this.visible) {
            if (this.isMouseDown) {
                this.sliderPosition = (float)(mouseX - (this.x + 4)) / (float)(this.width - 8);
                if (this.sliderPosition < 0.0f) {
                    this.sliderPosition = 0.0f;
                }
                if (this.sliderPosition > 1.0f) {
                    this.sliderPosition = 1.0f;
                }
                this.displayString = this.getDisplayString();
            }
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int w = (double)this.width * 0.05 < 4.0 ? 4 : (int)((double)this.width * 0.05);
            GuiTexturePos2D guiTexturePos2D = new GuiTexturePos2D(20.0f, 66.0f, w, this.height, 256.0f, 256.0f);
            Slider.drawCustomSizedTexture(this.x + (int)(this.sliderPosition * (float)(this.width - w)), this.y, w, this.height, guiTexturePos2D);
        }
    }

    public void setSliderPosition(float position) {
        this.sliderPosition = position;
        this.displayString = this.getDisplayString();
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        this.sliderPosition = (float)(mouseX - (this.x + 4)) / (float)(this.width - 8);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
        this.displayString = this.getDisplayString();
        this.isMouseDown = true;
        return true;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.isMouseDown = false;
    }
}

