/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI;

import com.alibaba.fastjson2.JSON;
import io.gitee.zhangsisiyao.ForgeAPI.Model.CustomModelLoader;
import io.gitee.zhangsisiyao.ForgeAPI.NetWork.NetworkPack;
import io.gitee.zhangsisiyao.ForgeAPI.Resources.CustomResource;
import io.gitee.zhangsisiyao.ForgeAPI.Resources.CustomResourceListener;
import io.gitee.zhangsisiyao.ForgeAPI.Resources.CustomResourcePack;
import io.gitee.zhangsisiyao.ForgeAPI.Resources.ResourceType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MinecraftCore {
    private static Map<String, CreativeTabs> creativeTabsMap = new HashMap<String, CreativeTabs>();

    public static void preinit() {
        MinecraftCore.registerCustomModelLoder(new CustomModelLoader());
        MinecraftCore.registerCustomResourceManger(new CustomResourceListener());
    }

    public static void init() {
    }

    public static void DisplayGui(@Nullable GuiScreen guiScreen) {
        Minecraft.getMinecraft().displayGuiScreen(guiScreen);
    }

    public static CreativeTabs registerCreativeTabs(String name, ItemStack icon) {
        final ItemStack itemStack = icon == null ? new ItemStack(Items.DIAMOND) : icon;
        CreativeTabs creativeTab = new CreativeTabs(I18n.format((String)name, (Object[])new Object[0])){

            public ItemStack getTabIconItem() {
                return itemStack;
            }
        };
        creativeTabsMap.put(name, creativeTab);
        return creativeTab;
    }

    public static Item registerItem(Item item) {
        GameRegistry.findRegistry(Item.class).registerAll((IForgeRegistryEntry[])new Item[]{item});
        return item;
    }

    public static void registerItems(Item ... items) {
        GameRegistry.findRegistry(Item.class).registerAll((IForgeRegistryEntry[])items);
    }

    public static void registerCustomResourceManger(ISelectiveResourceReloadListener loader) {
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)Minecraft.getMinecraft().getResourceManager();
        resourceManager.registerReloadListener((IResourceManagerReloadListener)loader);
    }

    public static void registerCustomModelLoder(ICustomModelLoader customModelLoader) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)customModelLoader);
    }

    public static void registerResource(ResourceLocation location, String absolutaPath, ResourceType type) {
        String prefix = "";
        String suffix = "";
        switch (type) {
            case TEXTURE: {
                prefix = "textures/";
                suffix = ".png";
            }
        }
        ResourceLocation resourceLocation = new ResourceLocation(location.getResourceDomain(), prefix + location.getResourcePath() + suffix);
        System.out.println(resourceLocation);
        CustomResourcePack.INSTANCE.resources.put(resourceLocation, new CustomResource(location, absolutaPath));
    }

    public static class NetWorkManger {
        private static Map<String, FMLEventChannel> channels = new HashMap<String, FMLEventChannel>();

        public static FMLEventChannel registerChannel(Object object, String name) {
            FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(name);
            channel.register(object);
            channels.put(name, channel);
            return channel;
        }

        public static void sendToServer(String channelName, NetworkPack pack) {
            byte[] array = JSON.toJSONString((Object)pack).getBytes(StandardCharsets.UTF_8);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])array);
            FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(buf), channelName);
            NetWorkManger.getChannel(channelName).sendToServer(packet);
        }

        public static NetworkPack toNetworkPack(byte[] array) {
            NetworkPack networkPack = (NetworkPack)JSON.parseObject((String)new String(array, StandardCharsets.UTF_8), NetworkPack.class);
            return networkPack;
        }

        public static FMLEventChannel getChannel(String channelName) {
            if (channels.containsKey(channelName)) {
                return channels.get(channelName);
            }
            return null;
        }
    }
}

