/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Texture;

import io.gitee.zhangsisiyao.ForgeAPI.Utils.TextureUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;

public class GuiTextureLoader
extends AbstractTexture {
    private BufferedImage imageBuffer;
    private List<BufferedImage> gifFrames;
    private List<Integer> gifTimes;
    private Thread gifTread;
    private int gifFrameIndex = 0;

    public GuiTextureLoader(File file) {
        if (TextureUtils.isGif(file)) {
            this.gifFrames = TextureUtils.getGifFrame(file);
            this.gifTimes = TextureUtils.getGifTime(file);
            this.startGifTread();
        }
        try {
            this.imageBuffer = TextureUtil.readBufferedImage((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GuiTextureLoader(BufferedImage image) {
        this.imageBuffer = image;
    }

    public GuiTextureLoader(String urlValue) {
        URL url = null;
        try {
            url = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            this.imageBuffer = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadTexture(IResourceManager resourceManager) throws IOException {
        this.deleteTexture();
        TextureUtil.uploadTextureImageAllocate((int)this.getGlTextureId(), (BufferedImage)this.imageBuffer, (boolean)false, (boolean)true);
    }

    public BufferedImage getImageBuffer() {
        return this.imageBuffer;
    }

    public void bindTexture() {
        try {
            this.loadTexture(Minecraft.getMinecraft().getResourceManager());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startGifTread() {
        final long timeInterval = this.gifTimes.get(this.gifFrameIndex).intValue();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    GuiTextureLoader.this.imageBuffer = (BufferedImage)GuiTextureLoader.this.gifFrames.get(GuiTextureLoader.this.gifFrameIndex);
                    GuiTextureLoader.this.gifFrameIndex++;
                    if (GuiTextureLoader.this.gifFrameIndex == GuiTextureLoader.this.gifFrames.size()) {
                        GuiTextureLoader.this.gifFrameIndex = 0;
                    }
                    try {
                        Thread.sleep(timeInterval);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        this.gifTread = new Thread(runnable);
        this.gifTread.setDaemon(true);
        this.gifTread.start();
    }

    public void stopGifTread() {
        if (this.gifTread != null && this.gifTread.isAlive()) {
            this.gifTread.interrupt();
        }
    }

    public int getTextureId() {
        return this.glTextureId;
    }

    public void deleteTexture() {
        if (this.getGlTextureId() != -1) {
            TextureUtil.deleteTexture((int)this.glTextureId);
        }
    }
}

