/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhangsisiyao.ForgeAPI.Utils.Svg;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class SvgUtil {
    private static final boolean DEBUG = false;

    public static <T extends Node> String convertElemToSVG(T element) {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            transformer.transform(new DOMSource(element), new StreamResult(buffer));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String elementStr = buffer.toString();
        return elementStr;
    }

    public static BufferedImage renderXMLToImage(String xmlContent, int width, int height) throws IOException {
        return SvgUtil.renderXMLToImage(xmlContent, width, height, false, null, null);
    }

    public static BufferedImage renderXMLToImage(String xmlContent, int width, int height, boolean stretch, String idRegex, Color replacementColor) throws IOException {
        String uri = "file:/fake.svg";
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        SVGDocument document = df.createSVGDocument(uri, (Reader)new StringReader(xmlContent));
        if (idRegex != null && replacementColor != null) {
            SvgUtil.replaceFill((Document)document, idRegex, replacementColor);
        }
        return SvgUtil.renderToImage((Document)document, width, height, stretch);
    }

    public static BufferedImage renderToImage(String uri, int width, int height) throws IOException {
        return SvgUtil.renderToImage(uri, width, height, false, null, null);
    }

    public static BufferedImage renderToImage(String uri, int width, int height, boolean stretch, String idRegex, Color replacementColor) throws IOException {
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        SVGDocument document = df.createSVGDocument(uri);
        if (idRegex != null && replacementColor != null) {
            SvgUtil.replaceFill((Document)document, idRegex, replacementColor);
        }
        return SvgUtil.renderToImage((Document)document, width, height, stretch);
    }

    public static BufferedImage renderToImage(Document document, int width, int height) {
        return SvgUtil.renderToImage(document, width, height, false);
    }

    public static void replaceFill(Document document, String idRegex, Color color) {
        String colorCode = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        NodeList children = document.getElementsByTagName("*");
        for (int i = 0; i < children.getLength(); ++i) {
            SVGElement element;
            if (!(children.item(i) instanceof SVGElement) || !(element = (SVGElement)children.item(i)).getId().matches(idRegex)) continue;
            String style = element.getAttributeNS(null, "style");
            style = style.replaceFirst("fill:#[a-zA-z0-9]+", "fill:" + colorCode);
            element.setAttributeNS(null, "style", style);
        }
    }

    public static BufferedImage renderToImage(Document document, int width, int height, boolean stretch) {
        ConcreteImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
        ImageRenderer renderer = rendererFactory.createStaticImageRenderer();
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext((UserAgent)new UserAgentAdapter());
        ctx.setDynamicState(0);
        GraphicsNode rootNode = builder.build(ctx, document);
        renderer.setTree(rootNode);
        float docWidth = (float)ctx.getDocumentSize().getWidth();
        float docHeight = (float)ctx.getDocumentSize().getHeight();
        float xscale = (float)width / docWidth;
        float yscale = (float)height / docHeight;
        if (!stretch) {
            float scale;
            xscale = scale = Math.min(xscale, yscale);
            yscale = scale;
        }
        AffineTransform px = AffineTransform.getScaleInstance(xscale, yscale);
        double tx = 0.0f + ((float)width / xscale - docWidth) / 2.0f;
        double ty = 0.0f + ((float)height / yscale - docHeight) / 2.0f;
        px.translate(tx, ty);
        renderer.updateOffScreen(width, height);
        renderer.setTree(rootNode);
        renderer.setTransform(px);
        renderer.repaint((Shape)new Rectangle(0, 0, width, height));
        return renderer.getOffScreen();
    }
}

